/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import snownee.jade.addon.JadeAddons;
import snownee.jade.addon.create.CreatePlugin;
import snownee.jade.addon.general.GeneralPlugin;
import snownee.jade.addon.lootr.LootrPlugin;
import snownee.jade.addon.mi.MIPlugin;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.util.CommonProxy;

@WailaPlugin
public class JadeAddonsBase
implements IWailaPlugin {
    public static final Map<String, Supplier<Supplier<IWailaPlugin>>> PLUGIN_LOADERS = Maps.newHashMap();
    public static IWailaClientRegistration client;
    private final List<IWailaPlugin> plugins = Lists.newArrayList();

    public JadeAddonsBase() {
        PLUGIN_LOADERS.forEach((modid, loader) -> {
            if (!CommonProxy.isModLoaded((String)modid)) {
                return;
            }
            try {
                this.plugins.add((IWailaPlugin)((Supplier)loader.get()).get());
            }
            catch (Throwable e) {
                JadeAddons.LOGGER.error("Failed to load plugin for %s".formatted(modid), e);
            }
        });
    }

    public void register(IWailaCommonRegistration registration) {
        this.plugins.removeIf($ -> {
            try {
                $.register(registration);
                return false;
            }
            catch (Throwable e) {
                JadeAddons.LOGGER.error("Failed to register plugin %s".formatted($.getClass().getName()), e);
                return true;
            }
        });
    }

    public void registerClient(IWailaClientRegistration registration) {
        client = registration;
        this.plugins.forEach($ -> $.registerClient(registration));
    }

    static {
        PLUGIN_LOADERS.put("jadeaddons", () -> GeneralPlugin::new);
        PLUGIN_LOADERS.put("create", () -> CreatePlugin::new);
        PLUGIN_LOADERS.put("lootr", () -> LootrPlugin::new);
        PLUGIN_LOADERS.put("modern_industrialization", () -> MIPlugin::new);
    }
}

