/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.signal;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class SignalVisual
extends AbstractBlockEntityVisual<SignalBlockEntity>
implements SimpleTickableVisual {
    private final TransformedInstance signalLight;
    private final TransformedInstance signalOverlay;
    private boolean previousIsRedLight;
    private SignalBlockEntity.OverlayState previousOverlayState;

    public SignalVisual(VisualizationContext ctx, SignalBlockEntity blockEntity, float partialTick) {
        super(ctx, (class_2586)blockEntity, partialTick);
        this.signalLight = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SIGNAL_OFF)).createInstance();
        this.signalOverlay = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.TRACK_SIGNAL_OVERLAY)).createInstance();
        this.setupVisual();
    }

    public void tick(TickableVisual.Context context) {
        this.setupVisual();
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.signalLight, this.signalOverlay});
    }

    protected void _delete() {
        this.signalLight.delete();
        this.signalOverlay.delete();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.signalLight);
    }

    private void setupVisual() {
        ITrackBlock trackBlock;
        class_2680 trackState;
        class_1937 level;
        class_2338 targetPosition;
        TrackTargetingBehaviour<SignalBoundary> target;
        SignalBlockEntity.OverlayState overlayState;
        block9: {
            block8: {
                float renderTime;
                SignalBlockEntity.SignalState signalState = ((SignalBlockEntity)this.blockEntity).getState();
                boolean isRedLight = signalState.isRedLight(renderTime = AnimationTickHolder.getRenderTime((class_1936)((SignalBlockEntity)this.blockEntity).method_10997()));
                if (isRedLight != this.previousIsRedLight) {
                    PartialModel partial = isRedLight ? AllPartialModels.SIGNAL_ON : AllPartialModels.SIGNAL_OFF;
                    this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)partial)).stealInstance((Instance)this.signalLight);
                }
                this.signalLight.setIdentityTransform().translate((class_2382)this.getVisualPosition());
                if (isRedLight) {
                    this.signalLight.light(240);
                }
                this.signalLight.setChanged();
                this.previousIsRedLight = isRedLight;
                overlayState = ((SignalBlockEntity)this.blockEntity).getOverlay();
                target = ((SignalBlockEntity)this.blockEntity).edgePoint;
                targetPosition = target.getGlobalPosition();
                level = ((SignalBlockEntity)this.blockEntity).method_10997();
                trackState = level.method_8320(targetPosition);
                class_2248 block = trackState.method_26204();
                if (!(block instanceof ITrackBlock)) break block8;
                trackBlock = (ITrackBlock)block;
                if (overlayState != SignalBlockEntity.OverlayState.SKIP) break block9;
            }
            this.previousOverlayState = null;
            this.signalOverlay.setZeroTransform().setChanged();
            return;
        }
        if (overlayState != this.previousOverlayState) {
            PartialModel partial;
            TrackTargetingBehaviour.RenderedTrackOverlayType type;
            this.previousOverlayState = overlayState;
            if (overlayState == SignalBlockEntity.OverlayState.DUAL) {
                type = TrackTargetingBehaviour.RenderedTrackOverlayType.DUAL_SIGNAL;
                partial = AllPartialModels.TRACK_SIGNAL_DUAL_OVERLAY;
            } else {
                type = TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL;
                partial = AllPartialModels.TRACK_SIGNAL_OVERLAY;
            }
            this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)partial)).stealInstance((Instance)this.signalOverlay);
            this.signalOverlay.setIdentityTransform().translate((class_2382)targetPosition.method_10059(this.renderOrigin()));
            trackBlock.prepareTrackOverlay(this.signalOverlay, (class_1922)level, targetPosition, trackState, target.getTargetBezier(), target.getTargetDirection(), type);
            this.signalOverlay.setChanged();
        }
    }
}

