/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.GlobalRailwayManager;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.SignalEdgeGroup;
import com.simibubi.create.foundation.utility.SavedDataUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class RailwaySavedData
extends class_18 {
    private Map<UUID, TrackGraph> trackNetworks = new HashMap<UUID, TrackGraph>();
    private Map<UUID, SignalEdgeGroup> signalEdgeGroups = new HashMap<UUID, SignalEdgeGroup>();
    private Map<UUID, Train> trains = new HashMap<UUID, Train>();

    public class_2487 method_75(class_2487 nbt) {
        GlobalRailwayManager railways = Create.RAILWAYS;
        DimensionPalette dimensions = new DimensionPalette();
        nbt.method_10566("RailGraphs", (class_2520)NBTHelper.writeCompoundList(railways.trackNetworks.values(), tg -> tg.write(dimensions)));
        nbt.method_10566("SignalBlocks", (class_2520)NBTHelper.writeCompoundList(railways.signalEdgeGroups.values(), seg -> {
            if (seg.fallbackGroup && !railways.trackNetworks.containsKey(seg.id)) {
                return null;
            }
            return seg.write();
        }));
        nbt.method_10566("Trains", (class_2520)NBTHelper.writeCompoundList(railways.trains.values(), t -> t.write(dimensions)));
        dimensions.write(nbt);
        return nbt;
    }

    private static RailwaySavedData load(class_2487 nbt) {
        RailwaySavedData sd = new RailwaySavedData();
        sd.trackNetworks = new HashMap<UUID, TrackGraph>();
        sd.signalEdgeGroups = new HashMap<UUID, SignalEdgeGroup>();
        sd.trains = new HashMap<UUID, Train>();
        DimensionPalette dimensions = DimensionPalette.read(nbt);
        NBTHelper.iterateCompoundList((class_2499)nbt.method_10554("RailGraphs", 10), c -> {
            TrackGraph graph = TrackGraph.read(c, dimensions);
            sd.trackNetworks.put(graph.id, graph);
        });
        NBTHelper.iterateCompoundList((class_2499)nbt.method_10554("SignalBlocks", 10), c -> {
            SignalEdgeGroup group = SignalEdgeGroup.read(c);
            sd.signalEdgeGroups.put(group.id, group);
        });
        NBTHelper.iterateCompoundList((class_2499)nbt.method_10554("Trains", 10), c -> {
            Train train = Train.read(c, sd.trackNetworks, dimensions);
            sd.trains.put(train.id, train);
        });
        for (TrackGraph graph : sd.trackNetworks.values()) {
            for (SignalBoundary signal : graph.getPoints(EdgePointType.SIGNAL)) {
                UUID groupId = (UUID)signal.groups.getFirst();
                UUID otherGroupId = (UUID)signal.groups.getSecond();
                if (groupId == null || otherGroupId == null) continue;
                SignalEdgeGroup group = sd.signalEdgeGroups.get(groupId);
                SignalEdgeGroup otherGroup = sd.signalEdgeGroups.get(otherGroupId);
                if (group == null || otherGroup == null) continue;
                group.putAdjacent(otherGroupId);
                otherGroup.putAdjacent(groupId);
            }
        }
        return sd;
    }

    public void method_17919(@NotNull File file) {
        SavedDataUtil.saveWithDatOld(this, file);
    }

    public Map<UUID, TrackGraph> getTrackNetworks() {
        return this.trackNetworks;
    }

    public Map<UUID, Train> getTrains() {
        return this.trains;
    }

    public Map<UUID, SignalEdgeGroup> getSignalBlocks() {
        return this.signalEdgeGroups;
    }

    private RailwaySavedData() {
    }

    public static RailwaySavedData load(MinecraftServer server) {
        return (RailwaySavedData)server.method_30002().method_17983().method_17924(RailwaySavedData::load, RailwaySavedData::new, "create_tracks");
    }
}

