/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.tableCloth;

import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.TableClothFilterSlot;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

public class TableClothFilteringBehaviour
extends FilteringBehaviour {
    public TableClothFilteringBehaviour(TableClothBlockEntity be) {
        super(be, new TableClothFilterSlot(be));
        this.withPredicate(is -> !(is.method_7909() instanceof FilterItem) && !(is.method_7909() instanceof ShoppingListItem));
        this.count = 1;
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        super.onShortInteract(player, hand, side, hitResult);
    }

    @Override
    public float getRenderDistance() {
        return 32.0f;
    }

    private TableClothBlockEntity dbe() {
        return (TableClothBlockEntity)this.blockEntity;
    }

    @Override
    public boolean mayInteract(class_1657 player) {
        return this.dbe().owner == null || player.method_5667().equals(this.dbe().owner);
    }

    @Override
    public boolean isSafeNBT() {
        return false;
    }

    @Override
    public class_5250 getLabel() {
        return CreateLang.translateDirect("table_cloth.price_per_order", new Object[0]);
    }

    @Override
    public boolean isCountVisible() {
        return !this.filter.isEmpty();
    }

    @Override
    public boolean setFilter(class_1799 stack) {
        int before = this.count;
        boolean result = super.setFilter(stack);
        this.count = before;
        return result;
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettingsBehaviour.ValueSettings settings, boolean ctrlDown) {
        if (this.getValueSettings().equals(settings)) {
            return;
        }
        this.count = Math.max(1, settings.value());
        this.blockEntity.method_5431();
        this.blockEntity.sendData();
        this.playFeedbackSound(this);
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        return new ValueSettingsBoard((class_2561)this.getLabel(), 100, 10, CreateLang.translatedOptions("table_cloth", "amount"), new ValueSettingsFormatter(this::formatValue));
    }

    @Override
    public class_5250 formatValue(ValueSettingsBehaviour.ValueSettings value) {
        return class_2561.method_43470((String)String.valueOf(Math.max(1, value.value())));
    }

    @Override
    public class_5250 getCountLabelForValueBox() {
        return class_2561.method_43470((String)(this.isCountVisible() ? String.valueOf(this.count) : ""));
    }

    @Override
    public boolean isActive() {
        return this.dbe().isShop();
    }
}

