/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.stockTicker;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlock;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.NetworkHooks;
import java.util.ArrayList;
import java.util.Iterator;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class StockTickerInteractionHandler {
    public static class_1269 interactWithLogisticsManager(class_1657 player, class_1937 level, class_1268 hand, class_1297 entity, @Nullable class_3966 hit) {
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        class_2338 targetPos = StockTickerInteractionHandler.getStockTickerPosition(entity);
        if (targetPos == null) {
            return class_1269.field_5811;
        }
        if (StockTickerInteractionHandler.interactWithLogisticsManagerAt(player, level, targetPos)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static boolean interactWithLogisticsManagerAt(class_1657 player, class_1937 level, class_2338 targetPos) {
        class_1799 mainHandItem = player.method_6047();
        if (AllItems.SHOPPING_LIST.isIn(mainHandItem)) {
            StockTickerInteractionHandler.interactWithShop(player, level, targetPos, mainHandItem);
            return true;
        }
        if (level.method_8608()) {
            return true;
        }
        class_2586 class_25862 = level.method_8321(targetPos);
        if (!(class_25862 instanceof StockTickerBlockEntity)) {
            return false;
        }
        StockTickerBlockEntity stbe = (StockTickerBlockEntity)class_25862;
        if (!stbe.behaviour.mayInteract(player)) {
            player.method_7353((class_2561)CreateLang.translate("stock_keeper.locked", new Object[0]).style(class_124.field_1061).component(), true);
            return true;
        }
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            boolean showLockOption = stbe.behaviour.mayAdministrate(player) && Create.LOGISTICS.isLockable(stbe.behaviour.freqId);
            boolean isCurrentlyLocked = Create.LOGISTICS.isLocked(stbe.behaviour.freqId);
            NetworkHooks.openScreen((class_3222)sp, (class_3908)stbe.new StockTickerBlockEntity.RequestMenuProvider(), buf -> {
                buf.writeBoolean(showLockOption);
                buf.writeBoolean(isCurrentlyLocked);
                buf.method_10807(targetPos);
            });
            stbe.getRecentSummary().divideAndSendTo(sp, targetPos);
        }
        return true;
    }

    private static void interactWithShop(class_1657 player, class_1937 level, class_2338 targetPos, class_1799 mainHandItem) {
        if (level.method_8608()) {
            return;
        }
        class_2586 class_25862 = level.method_8321(targetPos);
        if (!(class_25862 instanceof StockTickerBlockEntity)) {
            return;
        }
        StockTickerBlockEntity tickerBE = (StockTickerBlockEntity)class_25862;
        ShoppingListItem.ShoppingList list = ShoppingListItem.getList(mainHandItem);
        if (list == null) {
            return;
        }
        if (!tickerBE.behaviour.freqId.equals(list.shopNetwork())) {
            AllSoundEvents.DENY.playOnServer(level, (class_2382)player.method_24515());
            CreateLang.translate("stock_keeper.wrong_network", new Object[0]).style(class_124.field_1061).sendStatus(player);
            return;
        }
        Couple<InventorySummary> bakeEntries = list.bakeEntries((class_1936)level, null);
        InventorySummary paymentEntries = (InventorySummary)bakeEntries.getSecond();
        InventorySummary orderEntries = (InventorySummary)bakeEntries.getFirst();
        PackageOrder order = new PackageOrder(orderEntries.getStacksByCount());
        tickerBE.getAccurateSummary();
        InventorySummary recentSummary = tickerBE.getRecentSummary();
        for (BigItemStack entry : order.stacks()) {
            if (recentSummary.getCountOf(entry.stack) >= entry.count) continue;
            AllSoundEvents.DENY.playOnServer(level, (class_2382)player.method_24515());
            CreateLang.translate("stock_keeper.stock_level_too_low", new Object[0]).style(class_124.field_1061).sendStatus(player);
            return;
        }
        int occupiedSlots = 0;
        for (BigItemStack entry : paymentEntries.getStacksByCount()) {
            occupiedSlots += class_3532.method_15386((float)((float)entry.count / (float)entry.stack.method_7914()));
        }
        Iterator iterator = tickerBE.receivedPayments.iterator();
        while (iterator.hasNext()) {
            StorageView slot = (StorageView)iterator.next();
            if (!slot.isResourceBlank()) continue;
            --occupiedSlots;
        }
        if (occupiedSlots > 0) {
            AllSoundEvents.DENY.playOnServer(level, (class_2382)player.method_24515());
            CreateLang.translate("stock_keeper.cash_register_full", new Object[0]).style(class_124.field_1061).sendStatus(player);
            return;
        }
        for (Object simulate : (Iterator)Iterate.trueAndFalse) {
            InventorySummary tally = paymentEntries.copy();
            ArrayList<class_1799> toTransfer = new ArrayList<class_1799>();
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                int countOf;
                class_1799 item = player.method_31548().method_5438(i);
                if (item.method_7960() || (countOf = tally.getCountOf(item)) == 0) continue;
                int toRemove = Math.min(item.method_7947(), countOf);
                tally.add(item, -toRemove);
                if (simulate != false) continue;
                int newStackSize = item.method_7947() - toRemove;
                player.method_31548().method_5447(i, newStackSize == 0 ? class_1799.field_8037 : item.method_46651(newStackSize));
                toTransfer.add(item.method_46651(toRemove));
            }
            if (simulate != false && tally.getTotalCount() != 0) {
                AllSoundEvents.DENY.playOnServer(level, (class_2382)player.method_24515());
                CreateLang.translate("stock_keeper.too_broke", new Object[0]).style(class_124.field_1061).sendStatus(player);
                return;
            }
            if (simulate != false) continue;
            toTransfer.forEach(s -> TransferUtil.insertItem((Storage)tickerBE.receivedPayments, (class_1799)s));
        }
        tickerBE.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.PLAYER, order, null, ShoppingListItem.getAddress(mainHandItem));
        player.method_6122(class_1268.field_5808, class_1799.field_8037);
        if (!order.isEmpty()) {
            AllSoundEvents.STOCK_TICKER_TRADE.playOnServer(level, (class_2382)tickerBE.method_11016());
        }
    }

    public static class_2338 getStockTickerPosition(class_1297 entity) {
        class_1297 rootVehicle = entity.method_5668();
        if (!(rootVehicle instanceof SeatEntity)) {
            return null;
        }
        if (!(entity instanceof class_1309)) {
            return null;
        }
        if (AllEntityTypes.PACKAGE.is(entity)) {
            return null;
        }
        class_2338 pos = entity.method_24515();
        int stations = 0;
        class_2338 targetPos = null;
        for (class_2350 d : Iterate.horizontalDirections) {
            for (int y : Iterate.zeroAndOne) {
                class_2338 workstationPos = pos.method_10093(d).method_10086(y);
                if (!(entity.method_37908().method_8320(workstationPos).method_26204() instanceof StockTickerBlock)) continue;
                targetPos = workstationPos;
                ++stations;
            }
        }
        if (stations != 1) {
            return null;
        }
        return targetPos;
    }
}

