/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagerLink;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.content.logistics.packager.repackager.RepackagerBlockEntity;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlock;
import com.simibubi.create.content.logistics.packagerLink.WiFiParticle;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PackagerLinkBlockEntity
extends LinkWithBulbBlockEntity {
    public LogisticallyLinkedBehaviour behaviour;
    public UUID placedBy;
    private static final Map<class_2680, class_243> bulbOffsets = new HashMap<class_2680, class_243>();

    public PackagerLinkBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.placedBy = null;
    }

    public InventorySummary fetchSummaryFromPackager(@Nullable IdentifiedInventory ignoredHandler) {
        PackagerBlockEntity packager = this.getPackager();
        if (packager == null) {
            return InventorySummary.EMPTY;
        }
        if (packager.isTargetingSameInventory(ignoredHandler)) {
            return InventorySummary.EMPTY;
        }
        return packager.getAvailableItems();
    }

    public void playEffect() {
        AllSoundEvents.STOCK_LINK.playAt(this.field_11863, (class_2382)this.field_11867, 0.75f, 1.25f, false);
        class_243 vec3 = class_243.method_24953((class_2382)this.field_11867);
        class_2680 state = this.method_11010();
        float f = 1.0f;
        class_2738 face = state.method_28500((class_2769)PackagerLinkBlock.field_11007).orElse(class_2738.field_12475);
        if (face != class_2738.field_12475) {
            f = -1.0f;
        }
        if (face == class_2738.field_12471) {
            vec3 = vec3.method_1031(0.0, 0.25, 0.0);
        }
        vec3 = vec3.method_1019(class_243.method_24954((class_2382)state.method_28500((class_2769)PackagerLinkBlock.field_11177).orElse(class_2350.field_11035).method_10163()).method_1021((double)f * 0.125));
        this.pulse();
        this.field_11863.method_8406((class_2394)new WiFiParticle.Data(), vec3.field_1352, vec3.field_1351, vec3.field_1350, 1.0, face == class_2738.field_12473 ? -1.0 : 1.0, 1.0);
    }

    public Pair<PackagerBlockEntity, PackagingRequest> processRequest(class_1799 stack, int amount, String address, int linkIndex, MutableBoolean finalLink, int orderId, @Nullable PackageOrderWithCrafts context, @Nullable IdentifiedInventory ignoredHandler) {
        PackagerBlockEntity packager = this.getPackager();
        if (packager == null) {
            return null;
        }
        if (packager.isTargetingSameInventory(ignoredHandler)) {
            return null;
        }
        InventorySummary summary = packager.getAvailableItems();
        int availableCount = summary.getCountOf(stack);
        if (availableCount == 0) {
            return null;
        }
        int toWithdraw = Math.min(amount, availableCount);
        return Pair.of((Object)packager, (Object)PackagingRequest.create(stack, toWithdraw, address, linkIndex, finalLink, 0, orderId, context));
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.placedBy != null) {
            tag.method_25927("PlacedBy", this.placedBy);
        }
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.placedBy = tag.method_10545("PlacedBy") ? tag.method_25926("PlacedBy") : null;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.behaviour = new LogisticallyLinkedBehaviour(this, true);
        behaviours.add(this.behaviour);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.behaviour.redstonePowerChanged(PackagerLinkBlock.getPower(this.method_11010(), this.field_11863, this.field_11867));
        PackagerBlockEntity packager = this.getPackager();
        if (packager != null) {
            packager.recheckIfLinksPresent();
        }
    }

    @Nullable
    public PackagerBlockEntity getPackager() {
        class_2680 blockState = this.method_11010();
        if (this.behaviour.redstonePower == 15) {
            return null;
        }
        class_2338 source = this.field_11867.method_10093(PackagerLinkBlock.getConnectedDirection(blockState).method_10153());
        class_2586 class_25862 = this.field_11863.method_8321(source);
        if (!(class_25862 instanceof PackagerBlockEntity)) {
            return null;
        }
        PackagerBlockEntity packager = (PackagerBlockEntity)class_25862;
        if (packager instanceof RepackagerBlockEntity) {
            return null;
        }
        return packager;
    }

    @Override
    public class_2350 getBulbFacing(class_2680 state) {
        return PackagerLinkBlock.getConnectedDirection(state);
    }

    @Override
    public class_243 getBulbOffset(class_2680 state) {
        return bulbOffsets.computeIfAbsent(state, s -> {
            class_243 offset = VecHelper.voxelSpace((double)5.0, (double)6.0, (double)11.0);
            class_243 wallOffset = VecHelper.voxelSpace((double)11.0, (double)6.0, (double)5.0);
            class_2738 face = (class_2738)s.method_11654((class_2769)PackagerLinkBlock.field_11007);
            class_243 vec = face == class_2738.field_12471 ? wallOffset : offset;
            float angle = AngleHelper.horizontalAngle((class_2350)((class_2350)s.method_11654((class_2769)PackagerLinkBlock.field_11177)));
            if (face == class_2738.field_12473) {
                angle = -angle;
            }
            if (face == class_2738.field_12471) {
                angle = 0.0f;
            }
            return VecHelper.rotateCentered((class_243)vec, (double)angle, (class_2350.class_2351)class_2350.class_2351.field_11052);
        });
    }
}

