/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.factoryBoard;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class FactoryPanelConnection {
    public FactoryPanelPosition from;
    public int amount;
    public List<class_2350> path;
    public int arrowBendMode;
    public boolean success;
    public WeakReference<Object> cachedSource;
    private int arrowBendModeCurrentPathUses;

    public FactoryPanelConnection(FactoryPanelPosition from, int amount) {
        this.from = from;
        this.amount = amount;
        this.path = new ArrayList<class_2350>();
        this.success = true;
        this.arrowBendMode = -1;
        this.arrowBendModeCurrentPathUses = 0;
        this.cachedSource = new WeakReference<Object>(null);
    }

    public static FactoryPanelConnection read(class_2487 nbt) {
        FactoryPanelConnection connection = new FactoryPanelConnection(FactoryPanelPosition.read(nbt), nbt.method_10550("Amount"));
        connection.arrowBendMode = nbt.method_10550("ArrowBending");
        return connection;
    }

    public class_2487 write() {
        class_2487 nbt = this.from.write();
        nbt.method_10569("Amount", this.amount);
        nbt.method_10569("ArrowBending", this.arrowBendMode);
        return nbt;
    }

    public List<class_2350> getPath(class_1937 level, class_2680 state, FactoryPanelPosition to) {
        if (!this.path.isEmpty() && this.arrowBendModeCurrentPathUses == this.arrowBendMode) {
            return this.path;
        }
        boolean findSuitable = this.arrowBendMode == -1;
        this.arrowBendModeCurrentPathUses = this.arrowBendMode;
        FactoryPanelBehaviour fromBehaviour = FactoryPanelBehaviour.at((class_1920)level, to);
        class_243 diff = this.calculatePathDiff(state, to);
        class_243 start = fromBehaviour != null ? fromBehaviour.getSlotPositioning().getLocalOffset((class_1936)level, to.pos(), state).method_1019(class_243.method_24954((class_2382)to.pos())) : class_243.field_1353;
        float xRot = 57.295776f * FactoryPanelBlock.getXRot(state);
        float yRot = 57.295776f * FactoryPanelBlock.getYRot(state);
        block0: for (int actualMode = 0; actualMode <= 4; ++actualMode) {
            this.path.clear();
            if (!findSuitable && actualMode != this.arrowBendMode) continue;
            boolean desperateOption = actualMode == 4;
            class_2338 toTravelFirst = class_2338.field_10980;
            class_2338 toTravelLast = class_2338.method_49638((class_2374)diff.method_1021(2.0).method_1031(0.1, 0.1, 0.1));
            if (actualMode > 1) {
                boolean flipX = diff.field_1352 > 0.0 ^ actualMode % 2 == 1;
                boolean flipZ = diff.field_1350 > 0.0 ^ actualMode % 2 == 0;
                int ceilX = class_3532.method_38788((int)toTravelLast.method_10263(), (int)2);
                int ceilZ = class_3532.method_38788((int)toTravelLast.method_10260(), (int)2);
                int floorZ = class_3532.method_48116((int)toTravelLast.method_10260(), (int)2);
                int floorX = class_3532.method_48116((int)toTravelLast.method_10263(), (int)2);
                toTravelFirst = new class_2338(flipX ? floorX : ceilX, 0, flipZ ? floorZ : ceilZ);
                toTravelLast = new class_2338(!flipX ? floorX : ceilX, 0, !flipZ ? floorZ : ceilZ);
            }
            class_2350 lastDirection = null;
            class_2350 currentDirection = null;
            for (class_2338 toTravel : List.of(toTravelFirst, toTravelLast)) {
                boolean zIsFarther;
                boolean bl = zIsFarther = Math.abs(toTravel.method_10260()) > Math.abs(toTravel.method_10263());
                boolean zIsPreferred = desperateOption ? zIsFarther : actualMode % 2 == 1;
                List<class_2350> directionOrder = zIsPreferred ? List.of(class_2350.field_11035, class_2350.field_11043, class_2350.field_11039, class_2350.field_11034) : List.of(class_2350.field_11039, class_2350.field_11034, class_2350.field_11035, class_2350.field_11043);
                for (int i = 0; i < 100 && !toTravel.equals((Object)class_2338.field_10980); ++i) {
                    for (class_2350 d : directionOrder) {
                        if (lastDirection != null && d == lastDirection.method_10153() || currentDirection != null && toTravel.method_10093(d).method_19455((class_2382)class_2338.field_10980) >= toTravel.method_10093(currentDirection).method_19455((class_2382)class_2338.field_10980)) continue;
                        currentDirection = d;
                    }
                    lastDirection = currentDirection;
                    toTravel = toTravel.method_10093(currentDirection);
                    this.path.add(currentDirection);
                }
            }
            if (!findSuitable || desperateOption) break;
            class_2338 travelled = class_2338.field_10980;
            for (int i = 0; i < this.path.size() - 1; ++i) {
                class_2350 d = this.path.get(i);
                travelled = travelled.method_10093(d);
                class_243 testOffset = class_243.method_24954((class_2382)travelled).method_1021(0.5);
                testOffset = VecHelper.rotate((class_243)testOffset, (double)180.0, (class_2350.class_2351)class_2350.class_2351.field_11052);
                testOffset = VecHelper.rotate((class_243)testOffset, (double)(xRot + 90.0f), (class_2350.class_2351)class_2350.class_2351.field_11048);
                class_243 v = start.method_1019(testOffset = VecHelper.rotate((class_243)testOffset, (double)yRot, (class_2350.class_2351)class_2350.class_2351.field_11052));
                if (!level.method_18026(new class_238(v, v).method_1014(0.0078125))) continue block0;
            }
        }
        return this.path;
    }

    public class_243 calculatePathDiff(class_2680 state, FactoryPanelPosition to) {
        float xRot = 57.295776f * FactoryPanelBlock.getXRot(state);
        float yRot = 57.295776f * FactoryPanelBlock.getYRot(state);
        int slotDiffx = to.slot().xOffset - this.from.slot().xOffset;
        int slotDiffY = to.slot().yOffset - this.from.slot().yOffset;
        class_243 diff = class_243.method_24954((class_2382)to.pos().method_10059((class_2382)this.from.pos()));
        diff = VecHelper.rotate((class_243)diff, (double)(-yRot), (class_2350.class_2351)class_2350.class_2351.field_11052);
        diff = VecHelper.rotate((class_243)diff, (double)(-xRot - 90.0f), (class_2350.class_2351)class_2350.class_2351.field_11048);
        diff = VecHelper.rotate((class_243)diff, (double)-180.0, (class_2350.class_2351)class_2350.class_2351.field_11052);
        diff = diff.method_1031((double)slotDiffx * 0.5, 0.0, (double)slotDiffY * 0.5);
        diff = diff.method_18805(1.0, 0.0, 1.0);
        return diff;
    }
}

