/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.potion;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.tterrag.registrate.fabric.SimpleFlowableFluid;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Collection;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.class_1293;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class PotionFluid
extends VirtualFluid {
    public static PotionFluid createSource(SimpleFlowableFluid.Properties properties) {
        return new PotionFluid(properties, true);
    }

    public static PotionFluid createFlowing(SimpleFlowableFluid.Properties properties) {
        return new PotionFluid(properties, false);
    }

    public PotionFluid(SimpleFlowableFluid.Properties properties, boolean source) {
        super(properties, source);
    }

    public static FluidStack of(long amount, class_1842 potion, BottleType bottleType) {
        FluidStack fluidStack = new FluidStack(((PotionFluid)((Object)AllFluids.POTION.get())).method_15751(), amount);
        PotionFluid.addPotionToFluidStack(fluidStack, potion);
        NBTHelper.writeEnum((class_2487)fluidStack.getOrCreateTag(), (String)"Bottle", (Enum)bottleType);
        return fluidStack;
    }

    public static FluidStack withEffects(long amount, class_1842 potion, List<class_1293> customEffects) {
        FluidStack fluidStack = PotionFluid.of(amount, potion, BottleType.REGULAR);
        return PotionFluid.appendEffects(fluidStack, customEffects);
    }

    public static FluidStack addPotionToFluidStack(FluidStack fs, class_1842 potion) {
        class_2960 resourcelocation = CatnipServices.REGISTRIES.getKeyOrThrow(potion);
        if (potion == class_1847.field_8984) {
            fs.removeChildTag("Potion");
            return new FluidStack(fs.getFluid(), fs.getAmount(), fs.getTag());
        }
        fs.getOrCreateTag().method_10582("Potion", resourcelocation.toString());
        return new FluidStack(fs.getFluid(), fs.getAmount(), fs.getTag());
    }

    public static FluidStack appendEffects(FluidStack fs, Collection<class_1293> customEffects) {
        if (customEffects.isEmpty()) {
            return fs;
        }
        class_2487 compoundnbt = fs.getOrCreateTag();
        class_2499 listnbt = compoundnbt.method_10554("CustomPotionEffects", 9);
        for (class_1293 effectinstance : customEffects) {
            listnbt.add((Object)effectinstance.method_5582(new class_2487()));
        }
        compoundnbt.method_10566("CustomPotionEffects", (class_2520)listnbt);
        return new FluidStack(fs.getFluid(), fs.getAmount(), fs.getTag());
    }

    public static enum BottleType {
        REGULAR,
        SPLASH,
        LINGERING;

    }
}

