/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_332;
import net.minecraft.class_364;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.client.ClientNetworkManager;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiBuilder;
import reborncore.client.gui.widget.GuiButtonExtended;
import reborncore.client.gui.widget.GuiButtonUpDown;
import reborncore.common.network.IdentifiedPacket;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.util.Color;
import reborncore.common.util.Torus;
import techreborn.blockentity.machine.multiblock.FusionControlComputerBlockEntity;
import techreborn.packets.ServerboundPackets;

@Environment(value=EnvType.CLIENT)
public class GuiFusionReactor
extends GuiBase<BuiltScreenHandler> {
    private final FusionControlComputerBlockEntity blockEntity;

    public GuiFusionReactor(int syncID, class_1657 player, FusionControlComputerBlockEntity blockEntity) {
        super(player, (class_2586)blockEntity, (class_1703)blockEntity.createScreenHandler(syncID, player));
        this.blockEntity = blockEntity;
    }

    public void method_25426() {
        super.method_25426();
        this.method_37063((class_364)new GuiButtonUpDown(this.field_2776 + 121, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(5), GuiButtonUpDown.UpDownButtonType.FASTFORWARD));
        this.method_37063((class_364)new GuiButtonUpDown(this.field_2776 + 121 + 12, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(1), GuiButtonUpDown.UpDownButtonType.FORWARD));
        this.method_37063((class_364)new GuiButtonUpDown(this.field_2776 + 121 + 24, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(-1), GuiButtonUpDown.UpDownButtonType.REWIND));
        this.method_37063((class_364)new GuiButtonUpDown(this.field_2776 + 121 + 36, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(-5), GuiButtonUpDown.UpDownButtonType.FASTREWIND));
    }

    protected void method_2389(class_332 drawContext, float partialTicks, int mouseX, int mouseY) {
        super.method_2389(drawContext, partialTicks, mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;
        this.drawSlot(drawContext, 34, 47, layer);
        this.drawSlot(drawContext, 126, 47, layer);
        this.drawOutputSlot(drawContext, 80, 47, layer);
        if (this.blockEntity.isMultiblockValid()) {
            this.builder.drawHologramButton(drawContext, (GuiBase)this, 6, 4, mouseX, mouseY, layer);
        }
    }

    protected void method_2388(class_332 drawContext, int mouseX, int mouseY) {
        super.method_2388(drawContext, mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;
        this.builder.drawProgressBar(drawContext, (GuiBase)this, this.blockEntity.getProgressScaled(100), 100, 55, 51, mouseX, mouseY, GuiBuilder.ProgressDirection.RIGHT, layer);
        this.builder.drawProgressBar(drawContext, (GuiBase)this, this.blockEntity.getProgressScaled(100), 100, 105, 51, mouseX, mouseY, GuiBuilder.ProgressDirection.LEFT, layer);
        if (this.blockEntity.isMultiblockValid()) {
            this.addHologramButton(6, 4, 212, layer).clickHandler(this::hologramToggle);
            this.drawCentredText(drawContext, this.blockEntity.getStateText(), 20, Color.BLUE.darker().getColor(), layer);
            if (this.blockEntity.state == 2) {
                this.drawCentredText(drawContext, (class_2561)class_2561.method_43470((String)PowerSystem.getLocalizedPower((double)this.blockEntity.getPowerChange())).method_27693("/t"), 30, Color.GREEN.darker().getColor(), layer);
            }
        } else {
            this.builder.drawMultiblockMissingBar(drawContext, (GuiBase)this, layer);
            this.addHologramButton(76, 56, 212, layer).clickHandler(this::hologramToggle);
            this.builder.drawHologramButton(drawContext, (GuiBase)this, 76, 56, mouseX, mouseY, layer);
            Optional<Pair<Integer, Integer>> stackSize = this.getCoilStackCount();
            if (stackSize.isPresent()) {
                if ((Integer)stackSize.get().getLeft() > 0) {
                    this.drawCentredText(drawContext, (class_2561)class_2561.method_43470((String)"Required Coils: ").method_27693(String.valueOf(stackSize.get().getLeft())).method_27693("x64 +").method_27693(String.valueOf(stackSize.get().getRight())), 25, 0xFFFFFF, layer);
                } else {
                    this.drawCentredText(drawContext, (class_2561)class_2561.method_43470((String)"Required Coils: ").method_27693(String.valueOf(stackSize.get().getRight())), 25, 0xFFFFFF, layer);
                }
            }
        }
        drawContext.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Size: ").method_27693(String.valueOf(this.blockEntity.size)), 83, 81, 0xFFFFFF, true);
        drawContext.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)String.valueOf(this.blockEntity.getPowerMultiplier())).method_27693("x"), 10, 81, 0xFFFFFF, true);
        this.builder.drawMultiEnergyBar(drawContext, (GuiBase)this, 9, 19, this.blockEntity.getEnergy(), this.blockEntity.getMaxStoredPower(), mouseX, mouseY, 0, layer);
    }

    public void hologramToggle(GuiButtonExtended button, double x, double y) {
        this.blockEntity.renderMultiblock = this.blockEntity.renderMultiblock ^ !this.hideGuiElements();
    }

    private void sendSizeChange(int sizeDelta) {
        ClientNetworkManager.sendToServer((IdentifiedPacket)ServerboundPackets.createPacketFusionControlSize(sizeDelta, this.blockEntity.method_11016()));
    }

    public Optional<Pair<Integer, Integer>> getCoilStackCount() {
        if (!Torus.getTorusSizeCache().containsKey(this.blockEntity.size)) {
            return Optional.empty();
        }
        int count = Torus.getTorusSizeCache().get(this.blockEntity.size);
        return Optional.of(Pair.of((Object)(count / 64), (Object)(count % 64)));
    }
}

