/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier2;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class LaunchpadBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
BuiltScreenHandlerProvider {
    public static final int MAX_SELECTION = 3;
    private int selection = TechRebornConfig.launchpadDefaultSelection;

    public LaunchpadBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.LAUNCHPAD, pos, state);
    }

    public void handleGuiInputFromClient(int amount) {
        this.selection += amount;
        this.ensureSelectionInRange();
    }

    public void ensureSelectionInRange() {
        if (this.selection > 3) {
            this.selection = 3;
        }
        if (this.selection <= 0) {
            this.selection = 0;
        }
    }

    public double selectedSpeed() {
        return switch (this.selection) {
            case 0 -> TechRebornConfig.launchpadSpeedLow;
            case 1 -> TechRebornConfig.launchpadSpeedMedium;
            case 2 -> TechRebornConfig.launchpadSpeedHigh;
            case 3 -> TechRebornConfig.launchpadSpeedExtreme;
            default -> throw new IllegalArgumentException("Impossible launchpad selection value!");
        };
    }

    public int selectedEnergyCost() {
        return switch (this.selection) {
            case 0 -> TechRebornConfig.launchpadEnergyLow;
            case 1 -> TechRebornConfig.launchpadEnergyMedium;
            case 2 -> TechRebornConfig.launchpadEnergyHigh;
            case 3 -> TechRebornConfig.launchpadEnergyExtreme;
            default -> throw new IllegalArgumentException("Impossible launchpad selection value!");
        };
    }

    public String selectedTranslationKey() {
        return switch (this.selection) {
            case 0 -> "techreborn.message.info.block.techreborn.launchpad.low";
            case 1 -> "techreborn.message.info.block.techreborn.launchpad.medium";
            case 2 -> "techreborn.message.info.block.techreborn.launchpad.high";
            case 3 -> "techreborn.message.info.block.techreborn.launchpad.extreme";
            default -> throw new IllegalArgumentException("Impossible launchpad selection value!");
        };
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || this.getStored() <= 0L || !this.isActive(RedstoneConfiguration.POWER_IO)) {
            return;
        }
        if (world.method_8510() % (long)TechRebornConfig.launchpadInterval != 0L) {
            return;
        }
        this.ensureSelectionInRange();
        double speed = this.selectedSpeed();
        int energyCost = this.selectedEnergyCost();
        if (this.getStored() > (long)energyCost) {
            List entities = world.method_18467(class_1297.class, new class_238(0.0, 1.0, 0.0, 1.0, 2.0, 1.0).method_996(pos));
            if (entities.size() == 0) {
                return;
            }
            world.method_8396(null, pos, class_3417.field_15134, class_3419.field_15245, 1.0f, 1.0f);
            for (class_1297 entity : entities) {
                entity.method_5762(0.0, speed, 0.0);
            }
            this.useEnergy(energyCost);
        }
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.launchpadMaxEnergy;
    }

    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return TechRebornConfig.launchpadMaxInput;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.selection = tag.method_10550("selection");
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("selection", this.selection);
    }

    public boolean hasSlotConfig() {
        return false;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public class_1799 getToolDrop(class_1657 p0) {
        return TRContent.Machine.LAUNCHPAD.getStack();
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("launchpad").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).syncEnergyValue().sync(this::getSelection, this::setSelection).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getSelection() {
        return this.selection;
    }

    public void setSelection(int selection) {
        this.selection = selection;
    }
}

