/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class ElectricFurnaceBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    public final RebornInventory<ElectricFurnaceBlockEntity> inventory = new RebornInventory(3, "ElectricFurnaceBlockEntity", 64, (MachineBaseBlockEntity)this);
    final int inputSlot = 0;
    final int outputSlot = 1;
    int ticksSinceLastChange;
    private class_3861 currentRecipe;
    private int cookTime;
    private int cookTimeTotal;
    final int EnergyPerTick = 1;

    public ElectricFurnaceBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.ELECTRIC_FURNACE, pos, state);
    }

    private void setInvDirty(boolean isDirty) {
        this.inventory.setHashChanged(isDirty);
    }

    private boolean isInvDirty() {
        return this.inventory.hasChanged();
    }

    private void updateCurrentRecipe() {
        if (this.inventory.method_5438(0).method_7960()) {
            this.resetCrafter();
            return;
        }
        Optional testRecipe = this.field_11863.method_8433().method_8132(class_3956.field_17546, this.inventory, this.field_11863);
        if (!testRecipe.isPresent()) {
            this.resetCrafter();
            return;
        }
        if (!this.canAcceptOutput((class_3861)testRecipe.get(), 1)) {
            this.resetCrafter();
        }
        this.currentRecipe = (class_3861)testRecipe.get();
        this.cookTime = 0;
        this.cookTimeTotal = Math.max((int)((double)this.currentRecipe.method_8167() * (1.0 - this.getSpeedMultiplier())), 1);
        this.updateState();
    }

    private boolean canAcceptOutput(class_3861 recipe, int slot) {
        class_1799 recipeOutput = recipe.method_8110(this.method_10997().method_30349());
        if (recipeOutput.method_7960()) {
            return false;
        }
        if (this.inventory.method_5438(slot).method_7960()) {
            return true;
        }
        if (ItemUtils.isItemEqual((class_1799)this.inventory.method_5438(slot), (class_1799)recipeOutput, (boolean)true, (boolean)true)) {
            return recipeOutput.method_7947() + this.inventory.method_5438(slot).method_7947() <= recipeOutput.method_7914();
        }
        return false;
    }

    public boolean canCraftAgain() {
        if (this.inventory.method_5438(0).method_7960()) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        if (!this.canAcceptOutput(this.currentRecipe, 1)) {
            return false;
        }
        return this.getEnergy() >= (long)this.currentRecipe.method_8167() * this.getEuPerTick(1L);
    }

    private void resetCrafter() {
        this.currentRecipe = null;
        this.cookTime = 0;
        this.cookTimeTotal = 0;
        this.updateState();
    }

    private void updateState() {
        class_2248 furnaceBlock = this.method_10997().method_8320(this.field_11867).method_26204();
        if (furnaceBlock instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)furnaceBlock;
            boolean isActive = this.currentRecipe != null || this.canCraftAgain();
            blockMachineBase.setActive(Boolean.valueOf(isActive), this.field_11863, this.field_11867);
        }
        this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 3);
    }

    private boolean hasAllInputs(class_3861 recipe) {
        if (recipe == null) {
            return false;
        }
        if (this.inventory.method_5438(0).method_7960()) {
            return false;
        }
        return recipe.method_8115(this.inventory, this.field_11863);
    }

    private void craftRecipe(class_3861 recipe) {
        if (recipe == null) {
            return;
        }
        if (!this.canAcceptOutput(recipe, 1)) {
            return;
        }
        class_1799 outputStack = this.inventory.method_5438(1);
        if (outputStack.method_7960()) {
            this.inventory.method_5447(1, recipe.method_8110(this.method_10997().method_30349()).method_7972());
        } else {
            outputStack.method_7933(1);
        }
        this.inventory.method_5438(0).method_7934(1);
    }

    public int getProgressScaled(int scale) {
        if (this.cookTimeTotal != 0) {
            return this.cookTime * scale / this.cookTimeTotal;
        }
        return 0;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(int cookTime) {
        this.cookTime = cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        this.cookTimeTotal = cookTimeTotal;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        this.charge(2);
        if (world == null || world.field_9236) {
            return;
        }
        ++this.ticksSinceLastChange;
        if (this.ticksSinceLastChange == 20) {
            this.setInvDirty(true);
            this.ticksSinceLastChange = 0;
        }
        if (this.isInvDirty()) {
            if (this.currentRecipe == null) {
                this.updateCurrentRecipe();
            }
            if (!(this.currentRecipe == null || this.hasAllInputs(this.currentRecipe) && this.canAcceptOutput(this.currentRecipe, 1))) {
                this.resetCrafter();
            }
        }
        if (this.currentRecipe != null) {
            if (this.cookTime >= this.cookTimeTotal && this.hasAllInputs(this.currentRecipe)) {
                this.craftRecipe(this.currentRecipe);
                this.updateCurrentRecipe();
            } else if (this.cookTime < this.cookTimeTotal && this.getStored() > this.getEuPerTick(1L)) {
                this.useEnergy(this.getEuPerTick(1L));
                ++this.cookTime;
                if (!this.isMuffled() && (this.cookTime == 1 || this.cookTime % 20 == 0 && RecipeCrafter.soundHandler != null)) {
                    RecipeCrafter.soundHandler.playSound(false, (class_2586)this);
                }
            }
        }
        this.setInvDirty(false);
    }

    protected boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.electricFurnaceMaxEnergy;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return TechRebornConfig.electricFurnaceMaxInput;
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return TRContent.Machine.ELECTRIC_FURNACE.getStack();
    }

    public RebornInventory<ElectricFurnaceBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("electricfurnace").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 55, 45).outputSlot(1, 101, 45).energySlot(2, 8, 72).syncEnergyValue().sync(this::getCookTime, this::setCookTime).sync(this::getCookTimeTotal, this::setCookTimeTotal).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

