/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.configbuilder.entry.ConfigEntry;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_6880;

public abstract class AudioDeviceList
extends ListScreenListBase<AudioDeviceEntry> {
    public static final int CELL_HEIGHT = 36;
    @Nullable
    protected class_2960 icon;
    @Nullable
    protected class_2561 defaultDeviceText;
    @Nullable
    protected ConfigEntry<String> configEntry;

    public AudioDeviceList(int width, int height, int top) {
        super(width, height, top, 36);
        this.method_31322(false);
        this.method_31323(false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        AudioDeviceEntry entry = (AudioDeviceEntry)this.method_25308(mouseX, mouseY);
        if (entry == null) {
            return false;
        }
        if (this.method_37019() != entry) {
            return false;
        }
        if (!this.isSelected(entry.getDevice())) {
            this.field_22740.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.onSelect(entry);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void onSelect(AudioDeviceEntry entry) {
        ClientVoicechat client;
        if (this.configEntry != null) {
            this.configEntry.set(entry.device).save();
        }
        if ((client = ClientManager.getClient()) != null) {
            client.reloadAudio();
        }
    }

    public void method_25314(Collection<AudioDeviceEntry> entries) {
        super.method_25314(entries);
    }

    public void setAudioDevices(Collection<String> entries) {
        this.method_25314(Stream.concat(Stream.of(""), entries.stream()).map(s -> this.createAudioDeviceEntry((String)s, this.getVisibleName((String)s), this.icon, () -> this.isSelected((String)s))).toList());
    }

    public abstract AudioDeviceEntry createAudioDeviceEntry(String var1, class_2561 var2, @Nullable class_2960 var3, Supplier<Boolean> var4);

    public boolean isSelected(String name) {
        if (this.configEntry == null) {
            return false;
        }
        return this.configEntry.get().equals(name);
    }

    public class_2561 getVisibleName(String device) {
        if (device.isEmpty() && this.defaultDeviceText != null) {
            return this.defaultDeviceText;
        }
        return class_2561.method_43470((String)SoundManager.cleanDeviceName(device));
    }

    public boolean isEmpty() {
        return this.method_25396().isEmpty();
    }
}

