/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javashared;

import java.util.Arrays;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.AssocTypeID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.FunctionTypeID;
import org.openzen.zenscript.codemodel.type.GenericMapTypeID;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.IteratorTypeID;
import org.openzen.zenscript.codemodel.type.OptionalTypeID;
import org.openzen.zenscript.codemodel.type.RangeTypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitor;

public class JavaTypeCheckIfGenericVisitor
implements TypeVisitor<Boolean> {
    @Override
    public Boolean visitBasic(BasicTypeID basic) {
        return false;
    }

    @Override
    public Boolean visitArray(ArrayTypeID array) {
        return array.elementType.accept(this);
    }

    @Override
    public Boolean visitAssoc(AssocTypeID assoc) {
        return assoc.keyType.accept(this) != false || assoc.valueType.accept(this) != false;
    }

    @Override
    public Boolean visitGenericMap(GenericMapTypeID map) {
        return true;
    }

    @Override
    public Boolean visitIterator(IteratorTypeID iterator) {
        return true;
    }

    @Override
    public Boolean visitFunction(FunctionTypeID function) {
        return function.header.typeParameters.length > 0 || function.header.getReturnType().accept(this) != false || Arrays.stream(function.header.parameters).anyMatch(functionParameter -> functionParameter.type.accept(this));
    }

    @Override
    public Boolean visitDefinition(DefinitionTypeID definition) {
        return definition.isGeneric();
    }

    @Override
    public Boolean visitGeneric(GenericTypeID generic) {
        return true;
    }

    @Override
    public Boolean visitRange(RangeTypeID range) {
        return range.baseType.accept(this);
    }

    @Override
    public Boolean visitOptional(OptionalTypeID type) {
        return type.baseType.accept(this);
    }
}

