/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.crafttweaker.platform.Services;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7710;

@IRecipeHandler.For(value=class_1867.class)
public final class ShapelessRecipeHandler
implements IRecipeHandler<class_1867> {
    @Override
    public String dumpToCommandString(IRecipeManager<? super class_1867> manager, class_1867 recipe) {
        Object[] objectArray = new Object[3];
        objectArray[0] = StringUtil.quoteAndEscape(recipe.method_8114());
        objectArray[1] = ItemStackUtil.getCommandString(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_1867)recipe).method_8110(arg_0)));
        objectArray[2] = recipe.method_8117().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]"));
        return String.format("craftingTable.addShapeless(%s, %s, %s);", objectArray);
    }

    @Override
    public <U extends class_1860<?>> boolean doesConflict(IRecipeManager<? super class_1867> manager, class_1867 firstRecipe, U secondRecipe) {
        return Services.PLATFORM.doCraftingTableRecipesConflict(manager, (class_1860<?>)firstRecipe, secondRecipe);
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super class_1867> manager, class_1867 recipe) {
        List<IIngredient> ingredients = recipe.method_8117().stream().map(IIngredient::fromIngredient).toList();
        IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Metadata.GROUP, recipe.method_8112()).with(BuiltinRecipeComponents.Metadata.CRAFTING_BOOK_CATEGORY, recipe.method_45441()).with(BuiltinRecipeComponents.Input.INGREDIENTS, ingredients).with(BuiltinRecipeComponents.Output.ITEMS, IItemStack.of(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_1867)recipe).method_8110(arg_0)))).build();
        return Optional.of(decomposedRecipe);
    }

    @Override
    public Optional<class_1867> recompose(IRecipeManager<? super class_1867> manager, class_2960 name, IDecomposedRecipe recipe) {
        String group = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP);
        class_7710 category = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.CRAFTING_BOOK_CATEGORY);
        List<IIngredient> ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        if (ingredients.stream().anyMatch(IIngredient::isEmpty)) {
            throw new IllegalArgumentException("Invalid inputs: found empty ingredient in list " + ingredients);
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid output: empty item");
        }
        class_2371 recipeIngredients = ingredients.stream().map(IIngredient::asVanillaIngredient).collect(class_2371::method_10211, AbstractList::add, AbstractCollection::addAll);
        return Optional.of(new class_1867(name, group, category, output.getInternal(), recipeIngredients));
    }
}

