/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveAllGenericRecipes;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipe;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByModId;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByName;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByOutput;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByRegex;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.visitor.DataToJsonStringVisitor;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.RecipeManagerWrapper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.GenericRecipesManager")
@Document(value="vanilla/api/recipe/manager/GenericRecipesManager")
public enum GenericRecipesManager {
    INSTANCE;


    @ZenCodeType.Method
    public void addJsonRecipe(String name, MapData data) {
        JsonObject recipeObject = (JsonObject)IRecipeManager.JSON_RECIPE_GSON.fromJson(data.accept(DataToJsonStringVisitor.INSTANCE), JsonObject.class);
        if (!recipeObject.has("type")) {
            throw new IllegalArgumentException("Serializer type missing!");
        }
        if (recipeObject.get("type").getAsString().equals("crafttweaker:scripts")) {
            throw new IllegalArgumentException("Cannot add a recipe to the CraftTweaker Scripts recipe type!");
        }
        class_2960 recipeName = CraftTweakerConstants.rl(name);
        class_1860 result = class_1863.method_17720((class_2960)recipeName, (JsonObject)recipeObject);
        RecipeManagerWrapper recipeManagerWrapper = new RecipeManagerWrapper(result.method_17716());
        CraftTweakerAPI.apply(new ActionAddRecipe<class_1860>(recipeManagerWrapper, result, null));
    }

    @ZenCodeType.Method
    public class_1860<?> getRecipeByName(String name) {
        class_1860<?> recipe = this.getRecipeMap().get(new class_2960(name));
        if (recipe == null) {
            throw new IllegalArgumentException("No recipe found with name: \"" + name + "\"");
        }
        return recipe;
    }

    @ZenCodeType.Method
    public List<class_1860<?>> getRecipesByOutput(IIngredient output) {
        return this.getAllRecipes().stream().filter(recipe -> output.matches(IItemStack.of(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_1860)recipe).method_8110(arg_0))))).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allRecipes")
    public List<class_1860<?>> getAllRecipes() {
        return this.getAllManagers().stream().map(IRecipeManager::getAllRecipes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="recipeMap")
    public Map<class_2960, class_1860<?>> getRecipeMap() {
        return this.getAllManagers().stream().map(IRecipeManager::getRecipeMap).flatMap(recipeMap -> recipeMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Deprecated(forRemoval=true)
    @ZenCodeType.Method
    public void removeRecipe(IIngredient output) {
        this.remove(output);
    }

    @ZenCodeType.Method
    public void remove(IIngredient output) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByOutput(output));
    }

    @ZenCodeType.Method
    public void removeByInput(IItemStack input) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipe(iRecipe -> iRecipe.method_8117().stream().anyMatch(ingredient -> ingredient.method_8093(input.getInternal()))));
    }

    @Deprecated(forRemoval=true)
    public void removeByName(String name) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByName(name));
    }

    @ZenCodeType.Method
    public void removeByName(String ... names) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByName((class_2960[])Arrays.stream(names).map(class_2960::new).toArray(class_2960[]::new)));
    }

    @ZenCodeType.Method
    public void removeByModid(String modId) {
        this.removeByModid(modId, null);
    }

    @ZenCodeType.Method
    public void removeByModid(String modId, Predicate<String> exclude) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByModId(modId, exclude));
    }

    @ZenCodeType.Method
    public void removeByRegex(String regex) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByRegex(regex));
    }

    @ZenCodeType.Method
    public void removeAll() {
        CraftTweakerAPI.apply(new ActionRemoveAllGenericRecipes());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allManagers")
    public List<IRecipeManager<?>> getAllManagers() {
        return new ArrayList(RecipeTypeBracketHandler.getManagerInstances());
    }
}

