/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientEmpty;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction1D;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction2D;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.type.CTShapedRecipe;
import com.blamejared.crafttweaker.api.recipe.type.CTShapelessRecipe;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.recipe.CraftingTableRecipeManager")
@Document(value="vanilla/api/recipe/manager/CraftingTableRecipeManager")
public enum CraftingTableRecipeManager implements IRecipeManager<class_3955>
{
    INSTANCE;


    @ZenCodeType.Method
    public void addShaped(String recipeName, IItemStack output, IIngredient[][] ingredients, @ZenCodeType.Optional RecipeFunction2D recipeFunction) {
        recipeName = this.fixRecipeName(recipeName);
        CraftTweakerAPI.apply(new ActionAddRecipe<CTShapedRecipe>(this, new CTShapedRecipe(recipeName, output, ingredients, MirrorAxis.NONE, recipeFunction), "shaped"));
    }

    @ZenCodeType.Method
    public void addShapedPattern(String recipeName, IItemStack output, String[] pattern, Map<String, IIngredient> keys, @ZenCodeType.Optional RecipeFunction2D recipeFunction) {
        recipeName = this.fixRecipeName(recipeName);
        int height = pattern.length;
        int width = Arrays.stream(pattern).mapToInt(String::length).max().orElse(0);
        IIngredient[][] ingredients = CraftingTableRecipeManager.dissolvePattern(pattern, keys, width, height);
        CraftTweakerAPI.apply(new ActionAddRecipe<CTShapedRecipe>(this, new CTShapedRecipe(recipeName, output, ingredients, MirrorAxis.NONE, recipeFunction), "shaped"));
    }

    @ZenCodeType.Method
    public void addShapedMirrored(String recipeName, MirrorAxis mirrorAxis, IItemStack output, IIngredient[][] ingredients, @ZenCodeType.Optional RecipeFunction2D recipeFunction) {
        recipeName = this.fixRecipeName(recipeName);
        CraftTweakerAPI.apply(new ActionAddRecipe<CTShapedRecipe>(this, new CTShapedRecipe(recipeName, output, ingredients, mirrorAxis, recipeFunction), "mirroring shaped"));
    }

    @ZenCodeType.Method
    public void addShapeless(String recipeName, IItemStack output, IIngredient[] ingredients, @ZenCodeType.Optional RecipeFunction1D recipeFunction) {
        recipeName = this.fixRecipeName(recipeName);
        CraftTweakerAPI.apply(new ActionAddRecipe<CTShapelessRecipe>(this, new CTShapelessRecipe(recipeName, output, ingredients, recipeFunction), "shapeless"));
    }

    @Override
    public class_3956<class_3955> getRecipeType() {
        return class_3956.field_17545;
    }

    public static IIngredient[][] dissolvePattern(String[] pattern, Map<String, IIngredient> keys, int width, int height) {
        keys.put(" ", IIngredientEmpty.INSTANCE);
        IIngredient[][] ingredients = new IIngredient[height][width];
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int row = 0; row < pattern.length; ++row) {
            for (int col = 0; col < pattern[row].length(); ++col) {
                String s = pattern[row].substring(col, col + 1);
                IIngredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new IllegalArgumentException("Pattern references symbol '" + s + "' but it is not defined in the key");
                }
                set.remove(s);
                ingredients[row][col] = ingredient;
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return ingredients;
    }
}

