/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data.visitor;

import com.blamejared.crafttweaker.api.data.BoolData;
import com.blamejared.crafttweaker.api.data.ByteArrayData;
import com.blamejared.crafttweaker.api.data.ByteData;
import com.blamejared.crafttweaker.api.data.DoubleData;
import com.blamejared.crafttweaker.api.data.FloatData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.IntArrayData;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.ListData;
import com.blamejared.crafttweaker.api.data.LongArrayData;
import com.blamejared.crafttweaker.api.data.LongData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.ShortData;
import com.blamejared.crafttweaker.api.data.StringData;
import com.blamejared.crafttweaker.api.data.visitor.DataToJsonStringVisitor;
import com.blamejared.crafttweaker.api.data.visitor.DataVisitor;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class DataToTextComponentVisitor
implements DataVisitor<class_2561> {
    private static final class_124 SYNTAX_HIGHLIGHTING_KEY = class_124.field_1075;
    private static final class_124 SYNTAX_HIGHLIGHTING_STRING = class_124.field_1060;
    private static final class_124 SYNTAX_HIGHLIGHTING_QUOTE = class_124.field_1080;
    private static final class_124 SYNTAX_HIGHLIGHTING_NUMBER = class_124.field_1065;
    private static final class_124 SYNTAX_HIGHLIGHTING_TYPE = class_124.field_1061;
    public static final Map<IData.Type, class_2561> DATA_TO_COMPONENT = (Map)class_156.method_654(new HashMap(), map -> {
        map.put(IData.Type.BOOL, class_2561.method_43470((String)"bool").method_27692(SYNTAX_HIGHLIGHTING_TYPE));
        map.put(IData.Type.BYTE_ARRAY, class_2561.method_43470((String)"byte[]").method_27692(SYNTAX_HIGHLIGHTING_TYPE));
        map.put(IData.Type.BYTE, class_2561.method_43470((String)"byte").method_27692(SYNTAX_HIGHLIGHTING_TYPE));
        map.put(IData.Type.DOUBLE, class_2561.method_43470((String)"double").method_27692(SYNTAX_HIGHLIGHTING_TYPE));
        map.put(IData.Type.FLOAT, class_2561.method_43470((String)"float").method_27692(SYNTAX_HIGHLIGHTING_TYPE));
        map.put(IData.Type.INT_ARRAY, class_2561.method_43470((String)"int[]").method_27692(SYNTAX_HIGHLIGHTING_TYPE));
        map.put(IData.Type.INT, class_2561.method_43470((String)"int").method_27692(SYNTAX_HIGHLIGHTING_TYPE));
        map.put(IData.Type.LONG_ARRAY, class_2561.method_43470((String)"long[]").method_27692(SYNTAX_HIGHLIGHTING_TYPE));
        map.put(IData.Type.LONG, class_2561.method_43470((String)"long").method_27692(SYNTAX_HIGHLIGHTING_TYPE));
        map.put(IData.Type.SHORT, class_2561.method_43470((String)"short").method_27692(SYNTAX_HIGHLIGHTING_TYPE));
        map.put(IData.Type.STRING, class_2561.method_43470((String)"string").method_27692(SYNTAX_HIGHLIGHTING_TYPE));
        map.put(IData.Type.LIST, class_2561.method_43473());
        map.put(IData.Type.MAP, class_2561.method_43473());
    });
    private static final class_124 SYNTAX_HIGHLIGHTING_AS = class_124.field_1080;
    private static final class_2561 KEYWORD_AS = class_2561.method_43470((String)" as ").method_27692(SYNTAX_HIGHLIGHTING_AS);
    private static final class_2561 MAP_EMPTY = class_2561.method_43470((String)"{}");
    private static final String MAP_OPEN = "{";
    private static final String MAP_CLOSE = "}";
    private static final class_2561 LIST_EMPTY = class_2561.method_43470((String)"[]");
    private static final String LIST_OPEN = "[";
    private static final String LIST_CLOSE = "]";
    private static final int INLINE_LIST_THRESHOLD = 8;
    private static final ByteCollection INLINE_ELEMENT_TYPES = new ByteOpenHashSet(new byte[]{1, 2, 3, 4, 5, 6});
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String NAME_VALUE_SEPARATOR = ":";
    private static final String ELEMENT_SEPARATOR = ",";
    private static final String ELEMENT_SPACING = " ";
    private static final String NEWLINE = "\n";
    private final String indentation;
    private final int depth;

    public DataToTextComponentVisitor(String indentation, int depth) {
        this.indentation = indentation;
        this.depth = depth;
    }

    private class_2561 getComponent(IData data) {
        return DATA_TO_COMPONENT.get((Object)data.getType());
    }

    private class_2561 visitSimple(IData data) {
        return class_2561.method_43470((String)data.accept(DataToJsonStringVisitor.INSTANCE)).method_10852(KEYWORD_AS).method_10852(this.getComponent(data)).method_27692(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    private class_2561 visitCollection(IData data) {
        class_5250 component = class_2561.method_43470((String)LIST_OPEN);
        for (int i = 0; i < data.length(); ++i) {
            class_5250 child = class_2561.method_43470((String)data.getAt(i).accept(DataToJsonStringVisitor.INSTANCE)).method_27692(SYNTAX_HIGHLIGHTING_NUMBER);
            component.method_27693(i == 0 ? "" : ELEMENT_SPACING).method_10852((class_2561)child);
            if (i == data.length() - 1) continue;
            component.method_27693(ELEMENT_SEPARATOR);
        }
        component.method_27693(LIST_CLOSE).method_10852(KEYWORD_AS).method_10852(this.getComponent(data));
        return component;
    }

    public class_2561 visit(IData data) {
        return data.accept(this);
    }

    @Override
    public class_2561 visitBool(BoolData data) {
        return this.visitSimple(data);
    }

    @Override
    public class_2561 visitByteArray(ByteArrayData data) {
        return this.visitCollection(data);
    }

    @Override
    public class_2561 visitByte(ByteData data) {
        return this.visitSimple(data);
    }

    @Override
    public class_2561 visitDouble(DoubleData data) {
        return this.visitSimple(data);
    }

    @Override
    public class_2561 visitFloat(FloatData data) {
        return this.visitSimple(data);
    }

    @Override
    public class_2561 visitIntArray(IntArrayData data) {
        return this.visitCollection(data);
    }

    @Override
    public class_2561 visitInt(IntData data) {
        return this.visitSimple(data);
    }

    @Override
    public class_2561 visitList(ListData data) {
        if (data.isEmpty()) {
            return LIST_EMPTY;
        }
        if (INLINE_ELEMENT_TYPES.contains(data.getInternal().method_10601()) && data.length() <= 8) {
            String seperator = ", ";
            class_5250 component = class_2561.method_43470((String)LIST_OPEN);
            for (int i = 0; i < data.length(); ++i) {
                if (i != 0) {
                    component.method_27693(seperator);
                }
                component.method_10852(new DataToTextComponentVisitor(this.indentation, this.depth).visit(data.getAt(i)));
            }
            component.method_27693(LIST_CLOSE);
            return component;
        }
        class_5250 component = class_2561.method_43470((String)LIST_OPEN);
        if (!this.indentation.isEmpty()) {
            component.method_27693(NEWLINE);
        }
        for (int i = 0; i < data.length(); ++i) {
            int nextDepth = this.depth + 1;
            class_5250 child = class_2561.method_43470((String)Strings.repeat((String)this.indentation, (int)nextDepth));
            child.method_10852(new DataToTextComponentVisitor(this.indentation, nextDepth).visit(data.getAt(i)));
            if (i != data.length() - 1) {
                child.method_27693(ELEMENT_SEPARATOR).method_27693(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
            }
            component.method_10852((class_2561)child);
        }
        if (!this.indentation.isEmpty()) {
            component.method_27693(NEWLINE).method_27693(Strings.repeat((String)this.indentation, (int)this.depth));
        }
        component.method_27693(LIST_CLOSE);
        return component;
    }

    @Override
    public class_2561 visitLongArray(LongArrayData data) {
        return this.visitCollection(data);
    }

    @Override
    public class_2561 visitLong(LongData data) {
        return this.visitSimple(data);
    }

    @Override
    public class_2561 visitMap(MapData data) {
        if (data.isEmpty()) {
            return MAP_EMPTY;
        }
        class_5250 component = class_2561.method_43470((String)MAP_OPEN);
        Set<String> keys = data.getKeys();
        if (!this.indentation.isEmpty()) {
            component.method_27693(NEWLINE);
        }
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            int nextDepth = this.depth + 1;
            class_5250 nextComponent = class_2561.method_43470((String)Strings.repeat((String)this.indentation, (int)nextDepth)).method_10852(this.handleEscapePretty(next)).method_27693(NAME_VALUE_SEPARATOR).method_27693(ELEMENT_SPACING).method_10852(new DataToTextComponentVisitor(this.indentation, nextDepth).visit(data.getAt(next)));
            if (iter.hasNext()) {
                nextComponent.method_27693(ELEMENT_SEPARATOR).method_27693(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
            }
            component.method_10852((class_2561)nextComponent);
        }
        if (!this.indentation.isEmpty()) {
            component.method_27693(NEWLINE).method_27693(Strings.repeat((String)this.indentation, (int)this.depth));
        }
        component.method_27693(MAP_CLOSE);
        return component;
    }

    @Override
    public class_2561 visitShort(ShortData data) {
        return this.visitSimple(data);
    }

    @Override
    public class_2561 visitString(StringData data) {
        String str = data.accept(DataToJsonStringVisitor.INSTANCE);
        String quote = str.substring(0, 1);
        class_5250 component = class_2561.method_43470((String)str.substring(1, str.length() - 1)).method_27692(SYNTAX_HIGHLIGHTING_STRING);
        return class_2561.method_43470((String)quote).method_27692(SYNTAX_HIGHLIGHTING_QUOTE).method_10852((class_2561)component).method_10852((class_2561)class_2561.method_43470((String)quote).method_27692(SYNTAX_HIGHLIGHTING_QUOTE));
    }

    private class_2561 handleEscapePretty(String str) {
        if (SIMPLE_VALUE.matcher(str).matches()) {
            return class_2561.method_43470((String)str).method_27692(SYNTAX_HIGHLIGHTING_KEY);
        }
        String escapedStr = class_2519.method_10706((String)str);
        String quote = escapedStr.substring(0, 1);
        class_5250 var2 = class_2561.method_43470((String)escapedStr.substring(1, escapedStr.length() - 1)).method_27692(SYNTAX_HIGHLIGHTING_KEY);
        return class_2561.method_43470((String)quote).method_10852((class_2561)var2).method_27693(quote);
    }
}

