/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.data.visitor.DataVisitor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.IntArrayData")
@ZenRegister
@Document(value="vanilla/api/data/IntArrayData")
public class IntArrayData
implements IData {
    private final class_2495 internal;

    public IntArrayData(class_2495 internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public IntArrayData(int[] internal) {
        this.internal = new class_2495(internal);
    }

    @Override
    public void put(String index, IData value) {
        try {
            this.getInternal().method_10535(Integer.parseInt(index), (class_2520)class_2497.method_23247((int)value.asInt()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Provided index: '%s' is not an Integer!".formatted(index));
        }
    }

    @Override
    public IData getAt(int index) {
        return TagToDataConverter.convert((class_2520)this.getInternal().method_10589(index));
    }

    @Override
    public void remove(int index) {
        this.getInternal().method_17807(index);
    }

    @Override
    public boolean contains(IData other) {
        if (other.isListable()) {
            List<IData> dataValues = other.asList();
            return dataValues != null && this.containsList(dataValues);
        }
        return this.getInternal().contains((Object)class_2497.method_23247((int)other.asInt()));
    }

    @Override
    public int compareTo(@NotNull IData other) {
        return Arrays.compare(this.asIntArray(), other.asIntArray());
    }

    @Override
    public boolean equalTo(IData other) {
        return Arrays.equals(this.asIntArray(), other.asIntArray());
    }

    @Override
    public List<IData> asList() {
        return this.getInternal().stream().map(IntData::new).collect(Collectors.toList());
    }

    @Override
    public boolean isListable() {
        return true;
    }

    @Override
    public byte[] asByteArray() {
        int[] ints = this.asIntArray();
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    @Override
    public int[] asIntArray() {
        return this.getInternal().method_10588();
    }

    @Override
    public long[] asLongArray() {
        int[] ints = this.asIntArray();
        long[] longs = new long[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            longs[i] = ints[i];
        }
        return longs;
    }

    @Override
    public int length() {
        return this.getInternal().size();
    }

    @Override
    @NotNull
    public Iterator<IData> iterator() {
        return this.asList().iterator();
    }

    public class_2495 getInternal() {
        return this.internal;
    }

    @Override
    public IntArrayData copy() {
        return new IntArrayData(this.getInternal());
    }

    @Override
    public IntArrayData copyInternal() {
        return new IntArrayData(this.getInternal().method_10591());
    }

    @Override
    public <T> T accept(DataVisitor<T> visitor) {
        return visitor.visitIntArray(this);
    }

    @Override
    public IData.Type getType() {
        return IData.Type.INT_ARRAY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntArrayData iData = (IntArrayData)o;
        return Objects.equals(this.getInternal(), iData.getInternal());
    }

    public int hashCode() {
        return Objects.hash(this.getInternal());
    }

    public String toString() {
        return this.getAsString();
    }
}

