/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe;

import com.blamejared.crafttweaker.api.action.recipe.ActionRecipeBase;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import org.apache.logging.log4j.Logger;

public class ActionRemoveRecipeByOutputInput<T extends class_1860<?>>
extends ActionRemoveRecipe<T> {
    private final IIngredient output;
    private final IIngredient input;

    public ActionRemoveRecipeByOutputInput(IRecipeManager<T> manager, IIngredient output, IIngredient input) {
        super(manager, (T recipe) -> {
            class_1799 recipeOutput = AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_1860)recipe).method_8110(arg_0));
            if (output.matches(IItemStack.ofMutable(recipeOutput))) {
                for (IItemStack item : input.getItems()) {
                    if (!((class_1856)recipe.method_8117().get(0)).method_8093(item.getInternal())) continue;
                    return true;
                }
            }
            return false;
        }, (ActionRecipeBase<T> action) -> "Removing \"" + action.getRecipeTypeName() + "\" recipes that output: " + output + "\" from an input of: " + input.getCommandString());
        this.output = output;
        this.input = input;
    }

    @Override
    public boolean validate(Logger logger) {
        if (this.output == null) {
            logger.warn("output cannot be null!", (Throwable)new IllegalArgumentException("output IItemStack cannot be null!"));
            return false;
        }
        if (this.input == null) {
            logger.warn("input cannot be null!", (Throwable)new IllegalArgumentException("input IIngredient cannot be null!"));
            return false;
        }
        return true;
    }
}

