/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import me.shedaniel.lightoverlay.common.CubicChunkPos;
import me.shedaniel.lightoverlay.common.LightOverlay;
import me.shedaniel.lightoverlay.common.fabric.LightOverlayTickerImpl;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3562;
import net.minecraft.class_3726;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import sun.misc.Unsafe;

public class LightOverlayTicker {
    private final class_310 minecraft = class_310.method_1551();
    private long ticks = 0L;
    private static int threadNumber = 0;
    private static final ThreadPoolExecutor EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
        Thread thread = new Thread(r, "light-overlay-" + threadNumber++);
        thread.setDaemon(true);
        return thread;
    });
    public final Set<CubicChunkPos> POS = Collections.synchronizedSet(new HashSet());
    public final Set<CubicChunkPos> CALCULATING_POS = Collections.synchronizedSet(new HashSet());
    public final Map<CubicChunkPos, Long2ByteMap> CHUNK_MAP = Maps.newConcurrentMap();
    private static final Supplier<class_1299<class_1297>> TESTING_ENTITY_TYPE = Suppliers.memoize(() -> {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Unsafe unsafe = (Unsafe)f.get(null);
            return (class_1299)unsafe.allocateInstance(class_1299.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    });

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void populateEntityType(class_1299<class_1297> type) {
        LightOverlayTickerImpl.populateEntityType(type);
    }

    public void queueChunk(CubicChunkPos pos) {
        if (LightOverlay.enabled && LightOverlay.caching && !this.CALCULATING_POS.contains(pos)) {
            this.POS.add(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(class_310 minecraft) {
        block23: {
            while (LightOverlay.enableOverlay.method_1436()) {
                LightOverlay.enabled = !LightOverlay.enabled;
            }
            try {
                ++this.ticks;
                if (minecraft.field_1724 == null || !LightOverlay.enabled) {
                    this.POS.clear();
                    this.CALCULATING_POS.clear();
                    EXECUTOR.getQueue().clear();
                    this.CHUNK_MAP.clear();
                    break block23;
                }
                class_746 player = minecraft.field_1724;
                class_638 world = minecraft.field_1687;
                class_3726 collisionContext = class_3726.method_16195((class_1297)player);
                if (!LightOverlay.caching) {
                    this.CALCULATING_POS.clear();
                    this.POS.clear();
                    this.CHUNK_MAP.clear();
                    class_2338 playerPos = player.method_24515();
                    assert (world != null);
                    class_3562 block = world.method_22336().method_15562(class_1944.field_9282);
                    class_3562 sky = LightOverlay.showNumber ? null : world.method_22336().method_15562(class_1944.field_9284);
                    class_2338.class_2339 downPos = new class_2338.class_2339();
                    Iterable iterate = class_2338.method_10094((int)(playerPos.method_10263() - LightOverlay.reach), (int)(playerPos.method_10264() - LightOverlay.reach), (int)(playerPos.method_10260() - LightOverlay.reach), (int)(playerPos.method_10263() + LightOverlay.reach), (int)(playerPos.method_10264() + LightOverlay.reach), (int)(playerPos.method_10260() + LightOverlay.reach));
                    Long2ByteOpenHashMap chunkData = new Long2ByteOpenHashMap();
                    this.CHUNK_MAP.put(new CubicChunkPos(0, 0, 0), (Long2ByteMap)chunkData);
                    for (class_2338 blockPos : iterate) {
                        downPos.method_10103(blockPos.method_10263(), blockPos.method_10264() - 1, blockPos.method_10260());
                        if (LightOverlay.showNumber) {
                            int level = LightOverlayTicker.getCrossLevel(blockPos, (class_2338)downPos, (class_1922)world, block, collisionContext);
                            if (level < 0) continue;
                            chunkData.put(blockPos.method_10063(), (byte)level);
                            continue;
                        }
                        class_6880 biome = !LightOverlay.mushroom ? world.method_23753(blockPos) : null;
                        byte type = this.getCrossType(blockPos, (class_6880<class_1959>)biome, (class_2338)downPos, (class_1922)world, block, sky, collisionContext);
                        if (type == 3) continue;
                        chunkData.put(blockPos.method_10063(), type);
                    }
                    break block23;
                }
                assert (class_310.method_1551().field_1687 != null);
                int height = class_3532.method_15384((double)((double)class_310.method_1551().field_1687.method_31605() / 32.0));
                int start = Math.floorDiv(class_310.method_1551().field_1687.method_31607(), 32);
                int playerPosX = (int)player.method_23317() >> 4;
                int playerPosY = (int)player.method_23318() >> 5;
                int playerPosZ = (int)player.method_23321() >> 4;
                int chunkRange = LightOverlay.getChunkRange();
                for (int chunkX = playerPosX - chunkRange; chunkX <= playerPosX + chunkRange; ++chunkX) {
                    for (int chunkY = Math.max(playerPosY - Math.max(1, chunkRange >> 1), start); chunkY <= playerPosY + Math.max(1, chunkRange >> 1) && chunkY <= start + height; ++chunkY) {
                        for (int chunkZ = playerPosZ - chunkRange; chunkZ <= playerPosZ + chunkRange; ++chunkZ) {
                            CubicChunkPos chunkPos;
                            if (class_3532.method_15382((int)(chunkX - playerPosX)) > chunkRange || class_3532.method_15382((int)(chunkY - playerPosY)) > chunkRange || class_3532.method_15382((int)(chunkZ - playerPosZ)) > chunkRange || this.CHUNK_MAP.containsKey(chunkPos = new CubicChunkPos(chunkX, chunkY, chunkZ))) continue;
                            this.queueChunk(chunkPos);
                        }
                    }
                }
                for (int p = 0; p < 3 && EXECUTOR.getQueue().size() < Runtime.getRuntime().availableProcessors(); ++p) {
                    double d1 = Double.MAX_VALUE;
                    double d2 = Double.MAX_VALUE;
                    double d3 = Double.MAX_VALUE;
                    CubicChunkPos c1 = null;
                    CubicChunkPos c2 = null;
                    CubicChunkPos c3 = null;
                    Set<CubicChunkPos> set = this.POS;
                    synchronized (set) {
                        Iterator<CubicChunkPos> iterator = this.POS.iterator();
                        while (iterator.hasNext()) {
                            int dz;
                            int dy;
                            CubicChunkPos pos = iterator.next();
                            if (class_3532.method_15382((int)(pos.x - playerPosX)) > chunkRange || class_3532.method_15382((int)(pos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || class_3532.method_15382((int)(pos.z - playerPosZ)) > chunkRange || this.CALCULATING_POS.contains(pos)) {
                                iterator.remove();
                                continue;
                            }
                            if (!LightOverlay.renderer.isFrustumVisible(pos.getMinBlockX(), pos.getMinBlockY(), pos.getMinBlockZ(), pos.getMaxBlockX(), pos.getMaxBlockY(), pos.getMaxBlockZ())) continue;
                            int dx = Math.abs(pos.x - playerPosX);
                            double distance = Math.sqrt(dx * dx + (dy = Math.abs(pos.y - playerPosY) << 1) * dy + (dz = Math.abs(pos.z - playerPosZ)) * dz);
                            if (distance < d1) {
                                d3 = d2;
                                d2 = d1;
                                d1 = distance;
                                c3 = c2;
                                c2 = c1;
                                c1 = pos;
                                continue;
                            }
                            if (distance < d2) {
                                d3 = d2;
                                d2 = distance;
                                c3 = c2;
                                c2 = pos;
                                continue;
                            }
                            if (!(distance < d3)) continue;
                            d3 = distance;
                            c3 = pos;
                        }
                    }
                    CubicChunkPos finalC1 = c1;
                    CubicChunkPos finalC2 = c2;
                    CubicChunkPos finalC3 = c3;
                    if (finalC1 == null) continue;
                    this.CALCULATING_POS.add(finalC1);
                    this.POS.remove(finalC1);
                    if (finalC2 != null) {
                        this.CALCULATING_POS.add(finalC2);
                        this.POS.remove(finalC2);
                        if (finalC3 != null) {
                            this.CALCULATING_POS.add(finalC3);
                            this.POS.remove(finalC3);
                        }
                    }
                    EXECUTOR.submit(() -> {
                        int playerPosX1 = (int)minecraft.field_1724.method_23317() >> 4;
                        int playerPosY1 = (int)minecraft.field_1724.method_23318() >> 5;
                        int playerPosZ1 = (int)minecraft.field_1724.method_23321() >> 4;
                        this.processChunk(finalC1, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        if (finalC2 != null) {
                            this.processChunk(finalC2, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                        if (finalC3 != null) {
                            this.processChunk(finalC3, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                    });
                }
                if (this.ticks % 50L == 0L) {
                    this.CHUNK_MAP.entrySet().removeIf(entry -> class_3532.method_15382((int)(((CubicChunkPos)entry.getKey()).x - playerPosX)) > chunkRange * 2 || class_3532.method_15382((int)(((CubicChunkPos)entry.getKey()).y - playerPosY)) > chunkRange * 2 || class_3532.method_15382((int)(((CubicChunkPos)entry.getKey()).z - playerPosZ)) > chunkRange * 2);
                }
            }
            catch (Throwable throwable) {
                LogManager.getLogger().throwing(throwable);
            }
        }
    }

    private void processChunk(CubicChunkPos pos, int playerPosX, int playerPosY, int playerPosZ, class_3726 context) {
        this.CALCULATING_POS.remove(pos);
        int chunkRange = LightOverlay.getChunkRange();
        if (class_3532.method_15382((int)(pos.x - playerPosX)) > chunkRange || class_3532.method_15382((int)(pos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || class_3532.method_15382((int)(pos.z - playerPosZ)) > chunkRange || this.POS.contains(pos)) {
            return;
        }
        try {
            assert (this.minecraft.field_1687 != null);
            this.calculateChunk(this.minecraft.field_1687.method_2935().method_2857(pos.x, pos.z, class_2806.field_12803, false), (class_1937)this.minecraft.field_1687, pos, context);
        }
        catch (Throwable throwable) {
            LogManager.getLogger().throwing(throwable);
        }
    }

    private void calculateChunk(class_2818 chunk, class_1937 world, CubicChunkPos chunkPos, class_3726 collisionContext) {
        if (world != null && chunk != null) {
            Long2ByteOpenHashMap chunkData = new Long2ByteOpenHashMap();
            class_3562 block = world.method_22336().method_15562(class_1944.field_9282);
            class_3562 sky = LightOverlay.showNumber ? null : world.method_22336().method_15562(class_1944.field_9284);
            for (class_2338 pos : class_2338.method_10094((int)chunkPos.getMinBlockX(), (int)chunkPos.getMinBlockY(), (int)chunkPos.getMinBlockZ(), (int)chunkPos.getMaxBlockX(), (int)chunkPos.getMaxBlockY(), (int)chunkPos.getMaxBlockZ())) {
                class_2338 down = pos.method_10074();
                if (LightOverlay.showNumber) {
                    int level = LightOverlayTicker.getCrossLevel(pos, down, (class_1922)chunk, block, collisionContext);
                    if (level < 0) continue;
                    chunkData.put(pos.method_10063(), (byte)level);
                    continue;
                }
                class_6880 biome = !LightOverlay.mushroom ? world.method_23753(pos) : null;
                byte type = this.getCrossType(pos, (class_6880<class_1959>)biome, down, (class_1922)chunk, block, sky, collisionContext);
                if (type == 3) continue;
                chunkData.put(pos.method_10063(), type);
            }
            this.CHUNK_MAP.put(chunkPos, (Long2ByteMap)chunkData);
        } else {
            this.CHUNK_MAP.remove(chunkPos);
        }
    }

    public byte getCrossType(class_2338 pos, class_6880<class_1959> biome, class_2338 down, class_1922 world, class_3562 block, class_3562 sky, class_3726 entityContext) {
        class_2680 blockBelowState = world.method_8320(down);
        class_2680 blockUpperState = world.method_8320(pos);
        class_265 upperCollisionShape = blockUpperState.method_26194(world, pos, entityContext);
        if (!LightOverlay.underwater && !blockUpperState.method_26227().method_15769()) {
            return 3;
        }
        if (class_2248.method_9501((class_265)upperCollisionShape, (class_2350)class_2350.field_11036)) {
            return 3;
        }
        if (blockUpperState.method_26219()) {
            return 3;
        }
        if (upperCollisionShape.method_1105(class_2350.class_2351.field_11052) > 0.0) {
            return 3;
        }
        if (blockUpperState.method_26164(class_3481.field_15463)) {
            return 3;
        }
        if (!blockBelowState.method_26170(world, down, TESTING_ENTITY_TYPE.get())) {
            return 3;
        }
        if (!LightOverlay.mushroom && LightOverlayTicker.isMushroom(biome)) {
            return 3;
        }
        int blockLightLevel = block.method_15543(pos);
        int skyLightLevel = sky.method_15543(pos);
        if (blockLightLevel > LightOverlay.higherCrossLevel) {
            return 3;
        }
        if (skyLightLevel > LightOverlay.higherCrossLevel) {
            return LightOverlay.higherCross;
        }
        return LightOverlay.lowerCrossLevel >= 0 && blockLightLevel > LightOverlay.lowerCrossLevel ? LightOverlay.lowerCross : (byte)1;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean isMushroom(class_6880<class_1959> biome) {
        return LightOverlayTickerImpl.isMushroom(biome);
    }

    public static int getCrossLevel(class_2338 pos, class_2338 down, class_1922 world, class_3562 view, class_3726 collisionContext) {
        class_2680 blockBelowState = world.method_8320(down);
        class_2680 blockUpperState = world.method_8320(pos);
        class_265 collisionShape = blockBelowState.method_26194(world, down, collisionContext);
        class_265 upperCollisionShape = blockUpperState.method_26194(world, pos, collisionContext);
        if (!LightOverlay.underwater && !blockUpperState.method_26227().method_15769()) {
            return -1;
        }
        if (!blockBelowState.method_26227().method_15769()) {
            return -1;
        }
        if (blockBelowState.method_26215()) {
            return -1;
        }
        if (class_2248.method_9501((class_265)upperCollisionShape, (class_2350)class_2350.field_11033)) {
            return -1;
        }
        return view.method_15543(pos);
    }
}

