/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.compat.computercraft;

import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlockEntity;
import com.mrh0.createaddition.config.Config;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularAccumulatorPeripheral
implements IPeripheral {
    private final String type;
    private final ModularAccumulatorBlockEntity tileEntity;

    public ModularAccumulatorPeripheral(String type, ModularAccumulatorBlockEntity tileEntity) {
        this.type = type;
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return iPeripheral == this;
    }

    @Nullable
    public Object getTarget() {
        return this.tileEntity;
    }

    @LuaFunction(mainThread=true)
    public final long getEnergy() {
        if (this.tileEntity.getControllerBE() == null) {
            return 0L;
        }
        return this.tileEntity.getControllerBE().getEnergy().getAmount();
    }

    @LuaFunction(mainThread=true)
    public final long getCapacity() {
        if (this.tileEntity.getControllerBE() == null) {
            return 0L;
        }
        return this.tileEntity.getControllerBE().getEnergy().getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final float getPercent() {
        if (this.tileEntity.getControllerBE() == null) {
            return 0.0f;
        }
        return this.tileEntity.getControllerBE().getCurrentValue();
    }

    @LuaFunction(mainThread=true)
    public long getMaxInsert() {
        return (Long)Config.ACCUMULATOR_MAX_INPUT.get();
    }

    @LuaFunction(mainThread=true)
    public long getMaxExtract() {
        return (Long)Config.ACCUMULATOR_MAX_OUTPUT.get();
    }

    @LuaFunction(mainThread=true)
    public int getHeight() {
        return this.tileEntity.getHeight();
    }

    @LuaFunction(mainThread=true)
    public int getWidth() {
        return this.tileEntity.getWidth();
    }
}

