/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.modular_accumulator;

import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlockEntity;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.apache.commons.lang3.tuple.Pair;

public class CAConnectivityHandler {
    public static <T extends class_2586> void formMulti(T be) {
        SearchCache cache = new SearchCache();
        ArrayList<T> frontier = new ArrayList<T>();
        frontier.add(be);
        CAConnectivityHandler.formMulti(be.method_11017(), (class_1922)be.method_10997(), cache, frontier);
    }

    private static <T extends class_2586> void formMulti(class_2591<?> type, class_1922 level, SearchCache<T> cache, List<T> frontier) {
        PriorityQueue<Pair<Integer, T>> creationQueue = CAConnectivityHandler.makeCreationQueue();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        class_2350.class_2351 mainAxis = ((IMultiBlockEntityContainer)((class_2586)frontier.get(0))).getMainConnectionAxis();
        int minX = mainAxis == class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minY = mainAxis != class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minZ = mainAxis == class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        for (class_2586 be : frontier) {
            class_2338 pos = be.method_11016();
            minX = Math.min(pos.method_10263(), minX);
            minY = Math.min(pos.method_10264(), minY);
            minZ = Math.min(pos.method_10260(), minZ);
        }
        if (mainAxis == class_2350.class_2351.field_11052) {
            minX -= ((IMultiBlockEntityContainer)((class_2586)frontier.get(0))).getMaxWidth();
        }
        if (mainAxis != class_2350.class_2351.field_11052) {
            minY -= ((IMultiBlockEntityContainer)((class_2586)frontier.get(0))).getMaxWidth();
        }
        if (mainAxis == class_2350.class_2351.field_11052) {
            minZ -= ((IMultiBlockEntityContainer)((class_2586)frontier.get(0))).getMaxWidth();
        }
        while (!frontier.isEmpty()) {
            class_2586 part = (class_2586)frontier.remove(0);
            class_2338 partPos = part.method_11016();
            if (visited.contains(partPos)) continue;
            visited.add(partPos);
            int amount = CAConnectivityHandler.tryToFormNewMulti(part, cache, true);
            if (amount > 1) {
                creationQueue.add(Pair.of((Object)amount, (Object)part));
            }
            for (class_2350.class_2351 axis : Iterate.axes) {
                T nextBe;
                class_2350 dir = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)axis);
                class_2338 next = partPos.method_10093(dir);
                if (next.method_10263() <= minX || next.method_10264() <= minY || next.method_10260() <= minZ || visited.contains(next) || (nextBe = CAConnectivityHandler.partAt(type, level, next)) == null || nextBe.method_11015()) continue;
                frontier.add(nextBe);
            }
        }
        visited.clear();
        while (!creationQueue.isEmpty()) {
            Pair<Integer, T> next = creationQueue.poll();
            class_2586 toCreate = (class_2586)next.getValue();
            if (visited.contains(toCreate.method_11016())) continue;
            visited.add(toCreate.method_11016());
            CAConnectivityHandler.tryToFormNewMulti(toCreate, cache, false);
        }
    }

    private static <T extends class_2586> int tryToFormNewMulti(T be, SearchCache<T> cache, boolean simulate) {
        int bestWidth = 1;
        int bestAmount = -1;
        if (!((IMultiBlockEntityContainer)be).isController()) {
            return 0;
        }
        int radius = ((IMultiBlockEntityContainer)be).getMaxWidth();
        for (int w = 1; w <= radius; ++w) {
            int amount = CAConnectivityHandler.tryToFormNewMultiOfWidth(be, w, cache, true);
            if (amount < bestAmount) continue;
            bestWidth = w;
            bestAmount = amount;
        }
        if (!simulate) {
            ModularAccumulatorBlockEntity ienergy;
            int beWidth = ((IMultiBlockEntityContainer)be).getWidth();
            if (beWidth == bestWidth && beWidth * beWidth * ((IMultiBlockEntityContainer)be).getHeight() == bestAmount) {
                return bestAmount;
            }
            CAConnectivityHandler.splitMultiAndInvalidate(be, cache, false);
            if (be instanceof ModularAccumulatorBlockEntity && (ienergy = (ModularAccumulatorBlockEntity)be).hasAccumulator()) {
                ienergy.setSize(0, bestAmount);
            }
            CAConnectivityHandler.tryToFormNewMultiOfWidth(be, bestWidth, cache, false);
            ((IMultiBlockEntityContainer)be).preventConnectivityUpdate();
            ((IMultiBlockEntityContainer)be).setWidth(bestWidth);
            ((IMultiBlockEntityContainer)be).setHeight(bestAmount / bestWidth / bestWidth);
            ((IMultiBlockEntityContainer)be).notifyMultiUpdated();
        }
        return bestAmount;
    }

    private static <T extends class_2586> int tryToFormNewMultiOfWidth(T be, int width, SearchCache<T> cache, boolean simulate) {
        ModularAccumulatorBlockEntity ienergy;
        int amount = 0;
        int height = 0;
        class_2591 type = be.method_11017();
        class_1937 level = be.method_10997();
        if (level == null) {
            return 0;
        }
        class_2338 origin = be.method_11016();
        InternalEnergyStorage beEnergy = null;
        if (be instanceof ModularAccumulatorBlockEntity && (ienergy = (ModularAccumulatorBlockEntity)be).hasAccumulator()) {
            beEnergy = ienergy.getEnergy();
        }
        class_2350.class_2351 axis = ((IMultiBlockEntityContainer)be).getMainConnectionAxis();
        block10: for (int yOffset = 0; yOffset < ((IMultiBlockEntityContainer)be).getMaxLength(axis, width); ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    ModularAccumulatorBlockEntity ienergyCon;
                    class_2338 conPos;
                    class_2350.class_2351 conAxis;
                    class_2586 controller;
                    int otherWidth;
                    class_2338 pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2350.class_2351.field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case class_2350.class_2351.field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case class_2350.class_2351.field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };
                    Optional<T> part = cache.getOrCache(type, (class_1922)level, pos);
                    if (part.isEmpty() || (otherWidth = ((IMultiBlockEntityContainer)(controller = (class_2586)part.get())).getWidth()) > width || otherWidth == width && ((IMultiBlockEntityContainer)controller).getHeight() == ((IMultiBlockEntityContainer)be).getMaxLength(axis, width) || axis != (conAxis = ((IMultiBlockEntityContainer)controller).getMainConnectionAxis()) || !(conPos = controller.method_11016()).equals((Object)origin) && (axis != class_2350.class_2351.field_11052 ? axis == class_2350.class_2351.field_11051 && conPos.method_10263() < origin.method_10263() || conPos.method_10264() < origin.method_10264() || axis == class_2350.class_2351.field_11048 && conPos.method_10260() < origin.method_10260() || axis == class_2350.class_2351.field_11051 && conPos.method_10263() + otherWidth > origin.method_10263() + width || conPos.method_10264() + otherWidth > origin.method_10264() + width || axis == class_2350.class_2351.field_11048 && conPos.method_10260() + otherWidth > origin.method_10260() + width : conPos.method_10263() < origin.method_10263() || conPos.method_10260() < origin.method_10260() || conPos.method_10263() + otherWidth > origin.method_10263() + width || conPos.method_10260() + otherWidth > origin.method_10260() + width)) break block10;
                    if (controller instanceof ModularAccumulatorBlockEntity && !(ienergyCon = (ModularAccumulatorBlockEntity)controller).hasAccumulator()) continue;
                }
            }
            amount += width * width;
            ++height;
        }
        if (simulate) {
            return amount;
        }
        Object extraData = ((IMultiBlockEntityContainer)be).getExtraData();
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    ModularAccumulatorBlockEntity ienergyPart;
                    class_2338 pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2350.class_2351.field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case class_2350.class_2351.field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case class_2350.class_2351.field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };
                    T part = CAConnectivityHandler.partAt(type, (class_1922)level, pos);
                    if (part == null || part == be) continue;
                    extraData = ((IMultiBlockEntityContainer)be).modifyExtraData(extraData);
                    if (part instanceof ModularAccumulatorBlockEntity && (ienergyPart = (ModularAccumulatorBlockEntity)part).hasAccumulator()) {
                        ModularAccumulatorBlockEntity ienergyBE;
                        InternalEnergyStorage storageAt = ienergyPart.getEnergy();
                        long energyAt = storageAt.getAmount();
                        if (energyAt > 0L && be instanceof ModularAccumulatorBlockEntity && (ienergyBE = (ModularAccumulatorBlockEntity)be).hasAccumulator() && beEnergy != null) {
                            beEnergy.internalProduceEnergy(energyAt);
                        }
                        storageAt.internalConsumeEnergy(storageAt.getCapacity());
                    }
                    CAConnectivityHandler.splitMultiAndInvalidate(part, cache, false);
                    ((IMultiBlockEntityContainer)part).setController(origin);
                    ((IMultiBlockEntityContainer)part).preventConnectivityUpdate();
                    cache.put(pos, be);
                    ((IMultiBlockEntityContainer)part).setHeight(height);
                    ((IMultiBlockEntityContainer)part).setWidth(width);
                    ((IMultiBlockEntityContainer)part).notifyMultiUpdated();
                }
            }
        }
        ((IMultiBlockEntityContainer)be).setExtraData(extraData);
        ((IMultiBlockEntityContainer)be).notifyMultiUpdated();
        return amount;
    }

    public static <T extends class_2586> void splitMulti(T be) {
        CAConnectivityHandler.splitMultiAndInvalidate(be, null, false);
    }

    private static <T extends class_2586> void splitMultiAndInvalidate(T be, @Nullable SearchCache<T> cache, boolean tryReconnect) {
        ModularAccumulatorBlockEntity ienergy;
        ModularAccumulatorBlockEntity ienergyBE;
        ModularAccumulatorBlockEntity ienergyBE2;
        class_1937 level = be.method_10997();
        if (level == null) {
            return;
        }
        if ((be = ((IMultiBlockEntityContainer)be).getControllerBE()) == null) {
            return;
        }
        int height = ((IMultiBlockEntityContainer)be).getHeight();
        int width = ((IMultiBlockEntityContainer)be).getWidth();
        if (width == 1 && height == 1) {
            return;
        }
        class_2338 origin = be.method_11016();
        ArrayList<T> frontier = new ArrayList<T>();
        class_2350.class_2351 axis = ((IMultiBlockEntityContainer)be).getMainConnectionAxis();
        long toDistribute = 0L;
        long maxCapacity = 0L;
        if (be instanceof ModularAccumulatorBlockEntity && (ienergyBE2 = (ModularAccumulatorBlockEntity)be).hasAccumulator()) {
            toDistribute = ienergyBE2.getEnergy().getAmount();
            maxCapacity = ienergyBE2.getSize(0);
            if (!be.method_11015()) {
                ienergyBE2.getEnergy().internalConsumeEnergy(maxCapacity);
            }
            ienergyBE2.setSize(0, 1);
        }
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    class_2338 pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2350.class_2351.field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case class_2350.class_2351.field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case class_2350.class_2351.field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };
                    T partAt = CAConnectivityHandler.partAt(be.method_11017(), (class_1922)level, pos);
                    if (partAt == null || !((IMultiBlockEntityContainer)partAt).getController().equals((Object)origin)) continue;
                    class_2586 controllerBE = ((IMultiBlockEntityContainer)partAt).getControllerBE();
                    ((IMultiBlockEntityContainer)partAt).setExtraData(controllerBE == null ? null : ((IMultiBlockEntityContainer)controllerBE).getExtraData());
                    ((IMultiBlockEntityContainer)partAt).removeController(true);
                    if (partAt != be) {
                        long split;
                        InternalEnergyStorage internalEnergyStorage;
                        long copy = toDistribute;
                        if (partAt instanceof ModularAccumulatorBlockEntity) {
                            ModularAccumulatorBlockEntity ienergyPart = (ModularAccumulatorBlockEntity)partAt;
                            internalEnergyStorage = ienergyPart.getEnergy();
                        } else {
                            internalEnergyStorage = null;
                        }
                        InternalEnergyStorage tank = internalEnergyStorage;
                        copy = split = Math.min(maxCapacity, toDistribute);
                        toDistribute -= split;
                        if (tank != null) {
                            tank.internalProduceEnergy(copy);
                        }
                    }
                    if (tryReconnect) {
                        frontier.add(partAt);
                        ((IMultiBlockEntityContainer)partAt).preventConnectivityUpdate();
                    }
                    if (cache == null) continue;
                    cache.put(pos, partAt);
                }
            }
        }
        if (be instanceof ModularAccumulatorBlockEntity && (ienergyBE = (ModularAccumulatorBlockEntity)be).hasAccumulator()) {
            ienergyBE.getEnergy().setEnergy(toDistribute);
        }
        if (be instanceof ModularAccumulatorBlockEntity && (ienergy = (ModularAccumulatorBlockEntity)be).hasAccumulator()) {
            ienergy.updateCache();
        }
        if (tryReconnect) {
            CAConnectivityHandler.formMulti(be.method_11017(), (class_1922)level, cache == null ? new SearchCache<T>() : cache, frontier);
        }
    }

    private static <T extends class_2586> PriorityQueue<Pair<Integer, T>> makeCreationQueue() {
        return new PriorityQueue<Pair<Integer, T>>((one, two) -> (Integer)two.getKey() - (Integer)one.getKey());
    }

    @Nullable
    public static <T extends class_2586> T partAt(class_2591<?> type, class_1922 level, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        if (be != null && be.method_11017() == type && !be.method_11015()) {
            return CAConnectivityHandler.checked(be);
        }
        return null;
    }

    @Nullable
    private static <T extends class_2586> T checked(class_2586 be) {
        if (be instanceof IMultiBlockEntityContainer) {
            return (T)be;
        }
        return null;
    }

    private static class SearchCache<T extends class_2586> {
        Map<class_2338, Optional<T>> controllerMap = new HashMap<class_2338, Optional<T>>();

        void put(class_2338 pos, T target) {
            this.controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(class_2338 pos) {
            this.controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(class_2338 pos) {
            return this.controllerMap.containsKey(pos);
        }

        Optional<T> getOrCache(class_2591<?> type, class_1922 level, class_2338 pos) {
            if (this.hasVisited(pos)) {
                return this.controllerMap.get(pos);
            }
            Object partAt = CAConnectivityHandler.partAt(type, level, pos);
            if (partAt == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            Object controller = CAConnectivityHandler.checked(level.method_8321(((IMultiBlockEntityContainer)partAt).getController()));
            if (controller == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            this.put(pos, controller);
            return Optional.of(controller);
        }
    }
}

