/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.liquid_blaze_burner;

import com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlockEntity;
import com.mrh0.createaddition.index.CAPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class LiquidBlazeBurnerRenderer
extends SafeBlockEntityRenderer<LiquidBlazeBurnerBlockEntity> {
    public LiquidBlazeBurnerRenderer(class_5614.class_5615 context) {
    }

    protected void renderSafe(LiquidBlazeBurnerBlockEntity te, float partialTicks, class_4587 ms, class_4597 bufferSource, int light, int overlay) {
        BlazeBurnerBlock.HeatLevel heatLevel = te.getHeatLevelFromBlock();
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        class_1937 level = te.method_10997();
        class_2680 blockState = te.method_11010();
        float animation = te.headAnimation.getValue(partialTicks) * 0.175f;
        float horizontalAngle = AngleHelper.rad((double)te.headAngle.getValue(partialTicks));
        boolean canDrawFlame = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
        boolean drawGoggles = te.goggles;
        int hashCode = te.hashCode();
        LiquidBlazeBurnerRenderer.renderShared(ms, null, bufferSource, level, blockState, heatLevel, animation, horizontalAngle, canDrawFlame, drawGoggles, hashCode);
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 bufferSource, LerpedFloat headAngle, boolean conductor) {
        class_2680 state = context.state;
        BlazeBurnerBlock.HeatLevel heatLevel = BlazeBurnerBlock.getHeatLevelOf((class_2680)state);
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        if (!heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            heatLevel = BlazeBurnerBlock.HeatLevel.FADING;
        }
        class_1937 level = context.world;
        float horizontalAngle = AngleHelper.rad((double)headAngle.getValue(AnimationTickHolder.getPartialTicks((class_1936)level)));
        boolean drawGoggles = context.blockEntityData.method_10545("Goggles");
        int hashCode = context.hashCode();
        LiquidBlazeBurnerRenderer.renderShared(matrices.getViewProjection(), matrices.getModel(), bufferSource, level, state, heatLevel, 0.0f, horizontalAngle, false, drawGoggles, hashCode);
    }

    private static void renderShared(class_4587 ms, @Nullable class_4587 modelTransform, class_4597 bufferSource, class_1937 level, class_2680 blockState, BlazeBurnerBlock.HeatLevel heatLevel, float animation, float horizontalAngle, boolean canDrawFlame, boolean drawGoggles, int hashCode) {
        boolean blockAbove = animation > 0.125f;
        float time = AnimationTickHolder.getRenderTime((class_1936)level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = class_3532.method_15374((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float offset1 = class_3532.method_15374((float)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
        float offset2 = class_3532.method_15374((float)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
        float headY = offset - animation * 0.75f;
        class_4588 solid = bufferSource.getBuffer(class_1921.method_23577());
        class_4588 cutout = bufferSource.getBuffer(class_1921.method_23579());
        ms.method_22903();
        if (canDrawFlame && blockAbove) {
            SpriteShiftEntry spriteShift = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
            float spriteWidth = spriteShift.getTarget().method_4577() - spriteShift.getTarget().method_4594();
            float spriteHeight = spriteShift.getTarget().method_4575() - spriteShift.getTarget().method_4593();
            float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
            double vScroll = speed * time;
            vScroll -= Math.floor(vScroll);
            vScroll = vScroll * (double)spriteHeight / 2.0;
            double uScroll = speed * time / 2.0f;
            uScroll -= Math.floor(uScroll);
            uScroll = uScroll * (double)spriteWidth / 2.0;
            SuperByteBuffer flameBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.BLAZE_BURNER_FLAME, (class_2680)blockState);
            if (modelTransform != null) {
                flameBuffer.transform(modelTransform);
            }
            flameBuffer.shiftUVScrolling(spriteShift, (float)uScroll, (float)vScroll);
            LiquidBlazeBurnerRenderer.draw(flameBuffer, horizontalAngle, ms, cutout);
        }
        PartialModel blazeModel = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING) ? (blockAbove ? AllPartialModels.BLAZE_SUPER_ACTIVE : AllPartialModels.BLAZE_SUPER) : (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? (blockAbove && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.KINDLED) ? AllPartialModels.BLAZE_ACTIVE : AllPartialModels.BLAZE_IDLE) : AllPartialModels.BLAZE_INERT);
        SuperByteBuffer blazeBuffer = CachedBuffers.partial((PartialModel)blazeModel, (class_2680)blockState);
        if (modelTransform != null) {
            blazeBuffer.transform(modelTransform);
        }
        blazeBuffer.translate(0.0f, headY, 0.0f);
        LiquidBlazeBurnerRenderer.draw(blazeBuffer, horizontalAngle, ms, solid);
        if (drawGoggles) {
            PartialModel gogglesModel = blazeModel == AllPartialModels.BLAZE_INERT ? AllPartialModels.BLAZE_GOGGLES_SMALL : AllPartialModels.BLAZE_GOGGLES;
            SuperByteBuffer gogglesBuffer = CachedBuffers.partial((PartialModel)gogglesModel, (class_2680)blockState);
            if (modelTransform != null) {
                gogglesBuffer.transform(modelTransform);
            }
            gogglesBuffer.translate(0.0f, headY + 0.5f, 0.0f);
            LiquidBlazeBurnerRenderer.draw(gogglesBuffer, horizontalAngle, ms, solid);
        }
        SuperByteBuffer hatBuffer = CachedBuffers.partial((PartialModel)CAPartials.LIQUID_HAT, (class_2680)blockState);
        if (modelTransform != null) {
            hatBuffer.transform(modelTransform);
        }
        hatBuffer.translate(0.0f, headY, 0.0f);
        if (blazeModel == AllPartialModels.BLAZE_INERT) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)hatBuffer.translateY(0.5f)).center()).scale(0.75f)).uncenter();
        } else {
            hatBuffer.translateY(0.75f);
        }
        ((SuperByteBuffer)((SuperByteBuffer)hatBuffer.rotateCentered(horizontalAngle + (float)Math.PI, class_2350.field_11036)).translate(0.5f, 0.0f, 0.5f)).light(0xF000F0).renderInto(ms, solid);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            PartialModel rodsModel = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS;
            PartialModel rodsModel2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
            SuperByteBuffer rodsBuffer = CachedBuffers.partial((PartialModel)rodsModel, (class_2680)blockState);
            if (modelTransform != null) {
                rodsBuffer.transform(modelTransform);
            }
            ((SuperByteBuffer)rodsBuffer.translate(0.0f, offset1 + animation + 0.125f, 0.0f)).light(0xF000F0).renderInto(ms, solid);
            SuperByteBuffer rodsBuffer2 = CachedBuffers.partial((PartialModel)rodsModel2, (class_2680)blockState);
            if (modelTransform != null) {
                rodsBuffer2.transform(modelTransform);
            }
            ((SuperByteBuffer)rodsBuffer2.translate(0.0f, offset2 + animation - 0.1875f, 0.0f)).light(0xF000F0).renderInto(ms, solid);
        }
        ms.method_22909();
    }

    private static void draw(SuperByteBuffer buffer, float horizontalAngle, class_4587 ms, class_4588 vc) {
        ((SuperByteBuffer)buffer.rotateCentered(horizontalAngle, class_2350.field_11036)).light(0xF000F0).renderInto(ms, vc);
    }
}

