/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.storage.energy.lesu;

import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import techreborn.blockentity.storage.energy.EnergyStorageBlockEntity;
import techreborn.blockentity.storage.energy.lesu.LSUStorageBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class LapotronicSUBlockEntity
extends EnergyStorageBlockEntity
implements BuiltScreenHandlerProvider {
    public static final class_2350[] DIRECTIONS = class_2350.values();
    public static final int DIRECTIONS_LENGTH = DIRECTIONS.length;
    public static final byte[] FLAGS = new byte[DIRECTIONS_LENGTH];
    public static final byte[] OPP_FLAGS = new byte[DIRECTIONS_LENGTH];
    private int connectedBlocks = 0;
    public byte neighbors = 0;

    public LapotronicSUBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.LAPOTRONIC_SU, pos, state, "LESU", 2, TRContent.Machine.LAPOTRONIC_SU.block, RcEnergyTier.LOW, TechRebornConfig.lesuStoragePerBlock);
        this.checkOverfill = false;
        this.maxOutput = TechRebornConfig.lesuBaseOutput;
    }

    private void setMaxStorage() {
        this.maxStorage = (this.connectedBlocks + 1) * TechRebornConfig.lesuStoragePerBlock;
        if (this.maxStorage < 0) {
            this.maxStorage = Integer.MAX_VALUE;
        }
    }

    private void setIORate() {
        this.maxOutput = TechRebornConfig.lesuBaseOutput + this.connectedBlocks * TechRebornConfig.lesuExtraIOPerBlock;
        this.maxInput = this.connectedBlocks < 32 ? RcEnergyTier.LOW.getMaxInput() : (this.connectedBlocks < 128 ? RcEnergyTier.MEDIUM.getMaxInput() : RcEnergyTier.HIGH.getMaxInput());
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        if (this.getEnergy() > this.getMaxStoredPower()) {
            this.setEnergy(this.getMaxStoredPower());
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        byte flagInvalidNeighbors = 0;
        LinkedList<LSUStorageBlockEntity> canConnect = new LinkedList<LSUStorageBlockEntity>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        for (int i = 0; i < DIRECTIONS_LENGTH; ++i) {
            if ((this.neighbors & FLAGS[i]) == 0) continue;
            class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10093(DIRECTIONS[i]));
            if (class_25862 instanceof LSUStorageBlockEntity) {
                LSUStorageBlockEntity lsu_storage = (LSUStorageBlockEntity)class_25862;
                if (lsu_storage.master != null) continue;
                canConnect.add(lsu_storage);
                lsu_storage.addTo(visited);
                continue;
            }
            flagInvalidNeighbors = (byte)(flagInvalidNeighbors | FLAGS[i]);
        }
        if (flagInvalidNeighbors != 0) {
            this.neighbors = (byte)(this.neighbors ^ flagInvalidNeighbors);
            this.method_5431();
        }
        while (!canConnect.isEmpty()) {
            LSUStorageBlockEntity lsu_storage = (LSUStorageBlockEntity)((Object)canConnect.poll());
            lsu_storage.master = this;
            ++this.connectedBlocks;
            for (int i = 0; i < DIRECTIONS_LENGTH; ++i) {
                class_2586 class_25863;
                class_2338 linkPos;
                if ((lsu_storage.neighbors & FLAGS[i]) == 0 || !visited.add(linkPos = lsu_storage.posOffset(DIRECTIONS[i])) || !((class_25863 = this.field_11863.method_8321(linkPos)) instanceof LSUStorageBlockEntity)) continue;
                LSUStorageBlockEntity link_lsu_storage = (LSUStorageBlockEntity)class_25863;
                lsu_storage.links = (byte)(lsu_storage.links | FLAGS[i]);
                canConnect.add(link_lsu_storage);
            }
        }
        this.setMaxStorage();
        this.setIORate();
    }

    public void disconnectNetwork() {
        LSUStorageBlockEntity lsu_storage;
        int i;
        if (this.field_11863 == null) {
            return;
        }
        LinkedList<LSUStorageBlockEntity> canDelete = new LinkedList<LSUStorageBlockEntity>();
        for (i = 0; i < DIRECTIONS_LENGTH; ++i) {
            if ((this.neighbors & FLAGS[i]) == 0) continue;
            lsu_storage = this.fastGetLSUS(DIRECTIONS[i]);
            if (lsu_storage.master != this) continue;
            canDelete.add(lsu_storage);
        }
        while (!canDelete.isEmpty()) {
            lsu_storage = (LSUStorageBlockEntity)((Object)canDelete.poll());
            for (i = 0; i < DIRECTIONS_LENGTH; ++i) {
                if ((lsu_storage.links & FLAGS[i]) == 0) continue;
                canDelete.add(lsu_storage.fastGetLSUS(DIRECTIONS[i]));
            }
            lsu_storage.master = null;
            lsu_storage.links = 0;
        }
    }

    public final void checkNeighbors() {
        if (this.field_11863 == null) {
            return;
        }
        for (int i = 0; i < DIRECTIONS_LENGTH; ++i) {
            if (!(this.field_11863.method_8321(this.field_11867.method_10093(DIRECTIONS[i])) instanceof LSUStorageBlockEntity)) continue;
            this.neighbors = (byte)(this.neighbors | FLAGS[i]);
        }
        if (this.neighbors != 0) {
            this.method_5431();
        }
    }

    public LSUStorageBlockEntity fastGetLSUS(class_2350 direction) {
        assert (this.field_11863 != null);
        return (LSUStorageBlockEntity)this.field_11863.method_8321(this.field_11867.method_10093(direction));
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("lesu").player(player.method_31548()).inventory().hotbar().armor().complete(8, 18).addArmor().addInventory().blockEntity((class_2586)this).energySlot(0, 62, 45).energySlot(1, 98, 45).syncEnergyValue().sync(this::getConnectedBlocksNum, this::setConnectedBlocksNum).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getConnectedBlocksNum() {
        return this.connectedBlocks;
    }

    public void setConnectedBlocksNum(int value) {
        this.connectedBlocks = value;
        this.setMaxStorage();
        this.setIORate();
    }

    public void method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        tagCompound.method_10567("neighbors", this.neighbors);
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        this.neighbors = tagCompound.method_10545("neighbors") ? tagCompound.method_10571("neighbors") : (byte)63;
    }

    static {
        for (int i = 0; i < DIRECTIONS_LENGTH; ++i) {
            LapotronicSUBlockEntity.FLAGS[i] = (byte)(1 << DIRECTIONS[i].ordinal());
            LapotronicSUBlockEntity.OPP_FLAGS[i] = (byte)(1 << DIRECTIONS[i].method_10153().ordinal());
        }
    }
}

