/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument;

import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.rei.impl.client.search.argument.AlternativeArgument;
import me.shedaniel.rei.impl.client.search.argument.Argument;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CompoundArgument
extends ForwardingList<AlternativeArgument> {
    public static final CompoundArgument ALWAYS = new CompoundArgument(AlternativeArgument.EMPTY);
    private final AlternativeArgument[] arguments;
    private final List<AlternativeArgument> argumentList;

    private CompoundArgument(AlternativeArgument ... arguments) {
        this.arguments = arguments;
        this.argumentList = Arrays.asList(arguments);
    }

    public static CompoundArgument of(AlternativeArgument ... arguments) {
        if (arguments.length == 0) {
            return ALWAYS;
        }
        return new CompoundArgument(arguments);
    }

    public static Builder builder() {
        return new Builder();
    }

    public final boolean isAlways() {
        return this == ALWAYS;
    }

    protected List<AlternativeArgument> delegate() {
        return this.argumentList;
    }

    public static class Builder {
        private List<AlternativeArgument.Builder> arguments;

        public <T, R> Builder add(Argument.Builder<T, R> argument) {
            return this.add(new AlternativeArgument.Builder().add(argument));
        }

        public Builder add(AlternativeArgument.Builder argument) {
            if (this.arguments == null) {
                this.arguments = new ArrayList<AlternativeArgument.Builder>();
            }
            this.arguments.add(argument);
            return this;
        }

        public CompoundArgument build() {
            if (this.arguments == null) {
                return ALWAYS;
            }
            return CompoundArgument.of((AlternativeArgument[])this.arguments.stream().map(AlternativeArgument.Builder::build).toArray(AlternativeArgument[]::new));
        }
    }
}

