/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.fluid.MCFluidStack;
import com.blamejared.crafttweaker.api.fluid.MCFluidStackMutable;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStackMutable;
import com.blamejared.crafttweaker.api.loot.LootModifierManager;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.api.mod.Mod;
import com.blamejared.crafttweaker.api.recipe.handler.helper.CraftingTableRecipeConflictChecker;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.impl.fluid.SimpleFluidStack;
import com.blamejared.crafttweaker.mixin.AccessFakePlayer;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessBucketItem;
import com.blamejared.crafttweaker.platform.helper.inventory.IInventoryWrapper;
import com.blamejared.crafttweaker.platform.helper.world.inventory.TAInventoryWrapper;
import com.blamejared.crafttweaker.platform.services.IPlatformHelper;
import com.faux.customentitydata.api.CustomDataHelper;
import com.google.common.base.Suppliers;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModOrigin;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class FabricPlatformHelper
implements IPlatformHelper {
    public final Supplier<List<Mod>> modList = Suppliers.memoize(() -> FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).map(metadata -> new Mod(metadata.getId(), metadata.getName(), metadata.getVersion().getFriendlyString())).toList());
    public final Function<String, Optional<Mod>> modFinder = class_156.method_34866(modid -> this.modList.get().stream().filter(modObject -> modObject.id().equals(modid)).findFirst());
    private static final Supplier<Reflections> REFLECTIONS = Suppliers.memoize(FabricPlatformHelper::makeReflections);
    private static final Supplier<MappingResolver> MAPPING_RESOLVER = Suppliers.memoize(() -> FabricLoader.getInstance().getMappingResolver());

    private static Reflections makeReflections() {
        Collection urls = ClasspathHelper.forClassLoader();
        urls.removeIf(url -> url.getProtocol().contains("magic"));
        return new Reflections((Configuration)new ConfigurationBuilder().addUrls(urls).setParallel(true));
    }

    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public boolean isDataGen() {
        return false;
    }

    @Override
    public List<Mod> getMods() {
        return this.modList.get();
    }

    @Override
    public Optional<Mod> getMod(String modid) {
        return this.modFinder.apply(modid);
    }

    @Override
    public IItemStack createItemStack(class_1799 stack) {
        return new MCItemStack(stack);
    }

    @Override
    public IItemStack createItemStackMutable(class_1799 stack) {
        return new MCItemStackMutable(stack);
    }

    @Override
    public IFluidStack createFluidStack(class_3611 fluid, long amount, @Nullable class_2487 tag) {
        return new MCFluidStack(new SimpleFluidStack(fluid, Math.toIntExact(amount), tag));
    }

    @Override
    public IFluidStack createFluidStackMutable(class_3611 fluid, long amount, @Nullable class_2487 tag) {
        return new MCFluidStackMutable(new SimpleFluidStack(fluid, Math.toIntExact(amount), tag));
    }

    @Override
    public <T> IFluidStack createFluidStack(T stack) {
        if (stack instanceof SimpleFluidStack) {
            SimpleFluidStack fluidStack = (SimpleFluidStack)stack;
            return new MCFluidStack(fluidStack);
        }
        throw new IllegalArgumentException("Unable to create IFluidStack from '" + stack + "'!");
    }

    @Override
    public <T> IFluidStack createFluidStackMutable(T stack) {
        if (stack instanceof SimpleFluidStack) {
            SimpleFluidStack fluidStack = (SimpleFluidStack)stack;
            return new MCFluidStackMutable(fluidStack);
        }
        throw new IllegalArgumentException("Unable to create IFluidStack from '" + stack + "'!");
    }

    @Override
    public class_3611 getBucketContent(class_1755 item) {
        return ((AccessBucketItem)item).crafttweaker$getContent();
    }

    @Override
    public Path getGameDirectory() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public <T extends Annotation> Stream<? extends Class<?>> findClassesWithAnnotation(Class<T> annotationClass, Consumer<Mod> classProviderConsumer, Predicate<Either<T, Map<String, Object>>> annotationFilter) {
        Set typesAnnotatedWith = REFLECTIONS.get().getTypesAnnotatedWith(annotationClass);
        return typesAnnotatedWith.stream().filter(it -> it.isAnnotationPresent(annotationClass)).filter(it -> annotationFilter.test(Either.left(it.getAnnotation(annotationClass)))).peek(it -> this.getModsForClass((Class<?>)it).forEach(classProviderConsumer));
    }

    private List<Mod> getModsForClass(Class<?> clazz) {
        File classFile = new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath());
        ArrayList<Mod> mods = new ArrayList<Mod>();
        FabricLoader.getInstance().getAllMods().stream().filter(modContainer -> modContainer.getOrigin().getKind() == ModOrigin.Kind.PATH).forEach(modContainer -> {
            for (Path path : modContainer.getOrigin().getPaths()) {
                if (!path.toFile().equals(classFile)) continue;
                mods.add(new Mod(modContainer.getMetadata().getId(), modContainer.getMetadata().getName(), modContainer.getMetadata().getVersion().getFriendlyString()));
            }
        });
        return mods;
    }

    @Override
    public String findMappedMethodName(Class<?> clazz, String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        String namespace = MAPPING_RESOLVER.get().getCurrentRuntimeNamespace();
        String owner = clazz.getName();
        String descriptor = Arrays.stream(parameterTypes).map(Class::descriptorString).collect(Collectors.joining("", "(", ")" + returnType.descriptorString()));
        return MAPPING_RESOLVER.get().mapMethodName(namespace, owner, methodName, descriptor);
    }

    @Override
    public String findMappedFieldName(Class<?> clazz, String fieldName, Class<?> fieldType) {
        String namespace = MAPPING_RESOLVER.get().getCurrentRuntimeNamespace();
        String owner = clazz.getName();
        String descriptor = fieldType.descriptorString();
        return MAPPING_RESOLVER.get().mapFieldName(namespace, owner, fieldName, descriptor);
    }

    @Override
    public IInventoryWrapper getPlayerInventory(class_1657 player) {
        return new TAInventoryWrapper((InventoryStorage)PlayerInventoryStorage.of((class_1657)player));
    }

    @Override
    public boolean doCraftingTableRecipesConflict(IRecipeManager<?> manager, class_1860<?> first, class_1860<?> second) {
        return CraftingTableRecipeConflictChecker.checkConflicts(manager, first, second);
    }

    @Override
    public Map<class_2960, ILootModifier> getLootModifiersMap() {
        return LootModifierManager.INSTANCE.modifiers();
    }

    @Override
    public Set<class_5250> getFluidsForDump(class_1799 stack, class_1657 player, class_1268 hand) {
        Storage storage = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)class_1268.field_5808));
        if (storage == null) {
            return Set.of();
        }
        HashSet<class_5250> components = new HashSet<class_5250>();
        for (StorageView view : storage) {
            if (view.isResourceBlank()) continue;
            components.add(class_2561.method_43470((String)(class_7923.field_41173.method_10221((Object)((FluidVariant)view.getResource()).getFluid()) + " * " + view.getAmount())));
        }
        return components;
    }

    @Override
    public class_2487 getCustomData(class_1297 entity) {
        return CustomDataHelper.getCustomData((class_1297)entity);
    }

    @Override
    public class_2487 getPersistentData(class_3222 player) {
        return CustomDataHelper.getPersistentData((class_3222)player);
    }

    @Override
    public boolean isCustomIngredient(class_1856 ingredient) {
        return ingredient.getCustomIngredient() != null;
    }

    @Override
    public Stream<class_1799> getCustomIngredientItems(class_1856 ingredient) {
        return ingredient.getCustomIngredient() == null ? Stream.empty() : ingredient.getCustomIngredient().getMatchingStacks().stream();
    }

    @Override
    public Stream<GameProfile> fakePlayers() {
        return Stream.concat(Stream.of(AccessFakePlayer.getDEFAULT_PROFILE()), AccessFakePlayer.getFAKE_PLAYER_MAP().values().stream().map(class_1657::method_7334));
    }

    @Override
    public boolean isFakePlayer(class_1657 player) {
        return player instanceof FakePlayer;
    }
}

