/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.tag;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.tag.manager.TagManagerFactory;
import com.blamejared.crafttweaker.api.tag.manager.type.KnownTagManager;
import com.blamejared.crafttweaker.api.tag.manager.type.UnknownTagManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.InstantiationUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6864;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister(loaders={"crafttweaker", "tags"})
@ZenCodeType.Name(value="crafttweaker.api.tag.TagManager")
public final class CraftTweakerTagRegistry {
    private static final Supplier<Set<class_2960>> SERVER_ONLY_FOLDERS = Suppliers.memoize(() -> Services.REGISTRY.serverOnlyRegistries().stream().map(INSTANCE::makeTagFolder).map(class_2960::method_12829).filter(Objects::nonNull).collect(Collectors.toSet()));
    public static final String GLOBAL_NAME = "tags";
    @ZenCodeGlobals.Global(value="tags")
    public static final CraftTweakerTagRegistry INSTANCE = new CraftTweakerTagRegistry();
    private final Map<class_5321<? extends class_2378<?>>, ITagManager<?>> registeredManagers = new HashMap();
    private final Set<class_5321<? extends class_2378<?>>> knownManagers = new HashSet();
    private final Set<class_5321<? extends class_2378<?>>> knownManagersView = Collections.unmodifiableSet(this.knownManagers);

    private CraftTweakerTagRegistry() {
    }

    public <T> ITagManager<?> addManager(Class<? extends ITagManager<?>> cls) {
        ITagManager<?> manager = InstantiationUtil.getOrCreateInstance(cls);
        Objects.requireNonNull(manager, "Error while creating tag manager from class: '" + cls + "'! Make sure it has a default constructor or a public static INSTANCE field!");
        return this.addManager(manager);
    }

    public <T> ITagManager<?> addManager(ITagManager<?> manager) {
        this.registeredManagers.put(manager.resourceKey(), manager);
        if (manager.getClass().equals(KnownTagManager.class)) {
            this.knownManagers.add(manager.resourceKey());
        }
        return manager;
    }

    public Collection<ITagManager<?>> managers() {
        return Collections.unmodifiableCollection(this.registeredManagers.values());
    }

    public Collection<class_5321<? extends class_2378<?>>> knownManagers() {
        return this.knownManagersView;
    }

    public <T> Optional<ITagManager<?>> findManager(class_5321<? extends class_2378<T>> key) {
        return Optional.ofNullable(this.registeredManagers.get(key));
    }

    public <T> Optional<KnownTagManager<T>> findKnownManager(class_5321<? extends class_2378<T>> key) {
        return Optional.ofNullable(this.registeredManagers.get(key)).map(it -> it instanceof KnownTagManager ? (KnownTagManager)it : null);
    }

    public <T> Optional<? extends ITagManager<?>> tagManagerFromFolder(class_2960 tagFolder) {
        return this.registeredManagers.values().stream().filter(iTagManager -> tagFolder.equals((Object)class_2960.method_12829((String)iTagManager.tagFolder()))).findFirst();
    }

    public boolean isServerOnly(class_2960 tagFolder) {
        return SERVER_ONLY_FOLDERS.get().contains(tagFolder);
    }

    public boolean isKnownManager(class_5321<? extends class_2378<?>> key) {
        return this.knownManagers.contains(key);
    }

    public boolean isKnownManager(class_2960 tagFolder) {
        return this.tagManagerFromFolder(tagFolder).map(manager -> this.isKnownManager(manager.resourceKey())).orElse(false);
    }

    public <T> ITagManager<?> tagManager(class_5321<? extends class_2378<T>> key) {
        return this.findManager(key).orElseThrow(() -> new NoSuchElementException("No tag manager found for given key: " + key));
    }

    public <T> KnownTagManager<T> knownTagManager(class_5321<? extends class_2378<T>> key) {
        return this.findKnownManager(key).orElseThrow(() -> new NoSuchElementException("No known tag manager found for given key: " + key));
    }

    @ZenCodeType.Method
    public <T extends ITagManager<?>> T tagManager(class_2960 registryLocation) {
        return (T)this.findManager(class_5321.method_29180((class_2960)registryLocation)).orElseThrow(() -> new NoSuchElementException("No tag manager found for given location: " + registryLocation));
    }

    public void bind(class_3505 tagManager) {
        this.bind(tagManager.method_40096());
    }

    public void bind(Map<class_5321<? extends class_2378<?>>, class_6864.class_5748> tags) {
        this.bind(tags, new BindContext());
    }

    public void bind(Map<class_5321<? extends class_2378<?>>, class_6864.class_5748> tags, BindContext context) {
        ArrayList results = new ArrayList();
        HashSet knownKeys = new HashSet();
        class_5455 registryAccess = CraftTweakerAPI.getAccessibleElementsProvider().client().registryAccess();
        tags.forEach((resourceKey, networkPayload) -> {
            knownKeys.add(resourceKey);
            HashMap resultMap = new HashMap();
            class_2378 registry = registryAccess.method_30530(resourceKey);
            class_6864.method_40106((class_5321)((class_5321)GenericUtil.uncheck(resourceKey)), (class_2378)registry, (class_6864.class_5748)networkPayload, (key, holders) -> resultMap.put(key.comp_327(), holders));
            results.add(new class_3505.class_6863(resourceKey, resultMap));
        });
        registryAccess.method_40311().forEach(registryEntry -> {
            if (knownKeys.contains(registryEntry.comp_350())) {
                return;
            }
            results.add(new class_3505.class_6863(registryEntry.comp_350(), new HashMap()));
        });
        this.bind(results, context);
    }

    public void bind(List<class_3505.class_6863<?>> results) {
        this.bind(results, new BindContext());
    }

    public void bind(List<class_3505.class_6863<?>> results, BindContext context) {
        this.registeredManagers.clear();
        this.knownManagers.clear();
        for (class_3505.class_6863<?> loadResult : results) {
            Optional<Class<Class>> taggableElement = CraftTweakerAPI.getRegistry().getTaggableElementFor(loadResult.comp_328());
            if (context.registerKnownManagers()) {
                TagManagerFactory taggableElementFactory = CraftTweakerAPI.getRegistry().getTaggableElementFactory(loadResult.comp_328());
                taggableElement.ifPresentOrElse(it -> this.addManager((ITagManager<?>)taggableElementFactory.apply(loadResult.comp_328(), it)).bind(loadResult), () -> this.addManager(new UnknownTagManager(loadResult.comp_328())).bind(loadResult));
                continue;
            }
            this.addManager(new UnknownTagManager(loadResult.comp_328())).bind(loadResult);
        }
    }

    public String makeTagFolder(class_5321<?> key) {
        String tagDir = class_3505.method_40099((class_5321)((class_5321)GenericUtil.uncheck(key)));
        if (tagDir.startsWith("tags/")) {
            tagDir = tagDir.substring("tags/".length());
        }
        return tagDir;
    }

    public record BindContext(boolean registerKnownManagers) {
        public BindContext() {
            this(true);
        }
    }
}

