/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.FluidStackConstants;
import com.blamejared.crafttweaker.natives.resource.ExpandResourceLocation;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.fluid.IFluidStack")
@Document(value="vanilla/api/fluid/IFluidStack")
public interface IFluidStack
extends CommandStringDisplayable {
    @ZenCodeType.Method
    public static IFluidStack empty() {
        return FluidStackConstants.EMPTY.get();
    }

    public static <T> IFluidStack of(T convertable) {
        return Services.PLATFORM.createFluidStack(convertable);
    }

    public static IFluidStack of(class_3611 fluid, long amount) {
        return Services.PLATFORM.createFluidStack(fluid, amount, null);
    }

    public static IFluidStack of(class_3611 fluid, long amount, @Nullable class_2487 tag) {
        return Services.PLATFORM.createFluidStack(fluid, amount, tag);
    }

    public static <T> IFluidStack of(T convertable, boolean mutable) {
        return mutable ? IFluidStack.ofMutable(convertable) : IFluidStack.of(convertable);
    }

    public static IFluidStack of(class_3611 fluid, long amount, boolean mutable) {
        return mutable ? IFluidStack.ofMutable(fluid, amount, null) : IFluidStack.of(fluid, amount, null);
    }

    public static IFluidStack of(class_3611 fluid, long amount, @Nullable class_2487 tag, boolean mutable) {
        return mutable ? IFluidStack.ofMutable(fluid, amount, tag) : IFluidStack.of(fluid, amount, tag);
    }

    public static <T> IFluidStack ofMutable(T convertable) {
        return Services.PLATFORM.createFluidStackMutable(convertable);
    }

    public static IFluidStack ofMutable(class_3611 fluid, long amount) {
        return Services.PLATFORM.createFluidStackMutable(fluid, amount, null);
    }

    public static IFluidStack ofMutable(class_3611 fluid, long amount, @Nullable class_2487 tag) {
        return Services.PLATFORM.createFluidStackMutable(fluid, amount, tag);
    }

    @ZenCodeType.Getter(value="registryName")
    default public class_2960 getRegistryName() {
        return class_7923.field_41173.method_10221((Object)this.getFluid());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean matches(IFluidStack other) {
        return this.getAmount() >= other.getAmount() && this.isFluidEqual(other);
    }

    default public boolean isFluidEqual(IFluidStack other) {
        return this.getFluid() == other.getFluid() && FluidStackConstants.TAG_EQUALS.test(this, other);
    }

    @ZenCodeType.Getter(value="empty")
    public boolean isEmpty();

    @ZenCodeType.Getter(value="amount")
    public long getAmount();

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    public IFluidStack setAmount(int var1);

    @ZenCodeType.Method
    default public IFluidStack asMutable() {
        if (!this.isImmutable()) {
            return this;
        }
        return IFluidStack.of(this.getInternal());
    }

    @ZenCodeType.Method
    default public IFluidStack asImmutable() {
        if (this.isImmutable()) {
            return this;
        }
        return IFluidStack.of(this.getImmutableInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isImmutable")
    public boolean isImmutable();

    @ZenCodeType.Method
    default public IFluidStack copy() {
        if (this.isImmutable()) {
            return IFluidStack.of(this.getImmutableInternal());
        }
        return IFluidStack.ofMutable(this.getImmutableInternal());
    }

    @ZenCodeType.Getter(value="fluid")
    @ZenCodeType.Caster(implicit=true)
    public class_3611 getFluid();

    @ZenCodeType.Getter(value="tag")
    @ZenCodeType.Method
    public IData getTag();

    @ZenCodeType.Method
    public IFluidStack withTag(@ZenCodeType.Nullable IData var1);

    @ZenCodeType.Getter(value="hasTag")
    public boolean hasTag();

    @ZenCodeType.Caster(implicit=true)
    default public CTFluidIngredient asFluidIngredient() {
        return new CTFluidIngredient.FluidStackIngredient(this);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    default public CTFluidIngredient asList(CTFluidIngredient other) {
        ArrayList<CTFluidIngredient> elements = new ArrayList<CTFluidIngredient>();
        elements.add(this.asFluidIngredient());
        elements.add(other);
        return new CTFluidIngredient.CompoundFluidIngredient(elements);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public IData asIData() {
        MapData data = new MapData();
        data.put("fluid", ExpandResourceLocation.asData(this.getRegistryName()));
        if (this.getTag() != null) {
            data.put("nbt", this.getTag());
        }
        return data;
    }

    @Override
    default public String getCommandString() {
        IData data;
        class_3611 fluid = this.getFluid();
        StringBuilder builder = new StringBuilder().append("<fluid:").append(class_7923.field_41173.method_10221((Object)fluid)).append(">");
        if (this.hasTag() && !(data = this.getTag().copyInternal()).isEmpty()) {
            builder.append(".withTag(");
            builder.append(data.asString());
            builder.append(")");
        }
        if (!this.isEmpty() && this.getAmount() != 1L) {
            builder.append(" * ").append(this.getAmount());
        }
        return builder.toString();
    }

    public class_2487 getInternalTag();

    public <T> T getInternal();

    public <T> T getImmutableInternal();
}

