/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.GlobalRailwayManager;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.station.GlobalStation;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;

public class DumpRailwaysCommand {
    private static final int white = class_124.field_1068.method_532();
    private static final int blue = 11192544;
    private static final int darkBlue = 8955319;
    private static final int darkerBlue = 7046804;
    private static final int darkestBlue = 5466997;
    private static final int bright = 0xFFEFEF;
    private static final int orange = 16756064;

    static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"trains").requires(cs -> cs.method_9259(2))).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            DumpRailwaysCommand.fillReport(source.method_9225(), source.method_9222(), (s, f) -> source.method_9226(() -> class_2561.method_43470((String)s).method_27694(st -> st.method_36139(f.intValue())), false), c -> source.method_9226(() -> c, false));
            return 1;
        });
    }

    static void fillReport(class_3218 level, class_243 location, BiConsumer<String, Integer> chat, Consumer<class_2561> chatRaw) {
        GlobalRailwayManager railways = Create.RAILWAYS;
        chat.accept("", white);
        chat.accept("-+------<< Train Summary: >>------+-", white);
        int graphCount = railways.trackNetworks.size();
        chat.accept("Track Networks: " + graphCount, 11192544);
        chat.accept("Signal Groups: " + railways.signalEdgeGroups.size(), 11192544);
        int trainCount = railways.trains.size();
        chat.accept("Trains: " + trainCount, 11192544);
        chat.accept("", white);
        List<TrackGraph> nearest = railways.trackNetworks.values().stream().sorted((tg1, tg2) -> Float.compare(tg1.distanceToLocationSqr((class_1937)level, location), tg2.distanceToLocationSqr((class_1937)level, location))).limit(5L).toList();
        if (graphCount > 0) {
            chat.accept("Nearest Graphs: ", 16756064);
            chat.accept("", white);
            for (TrackGraph graph : nearest) {
                Collection<GlobalStation> stations;
                chat.accept(graph.id.toString().substring(0, 5) + " with " + graph.getNodes().size() + " Nodes", white);
                Collection<SignalBoundary> signals = graph.getPoints(EdgePointType.SIGNAL);
                if (!signals.isEmpty()) {
                    chat.accept(" -> " + signals.size() + " Signals", 11192544);
                }
                if ((stations = graph.getPoints(EdgePointType.STATION)).isEmpty()) continue;
                chat.accept(" -> " + stations.size() + " Stations", 11192544);
            }
            chat.accept("", white);
            if (graphCount > 5) {
                chat.accept("[...]", white);
                chat.accept("", white);
            }
        }
        List<Train> nearestTrains = railways.trains.values().stream().sorted((t1, t2) -> Float.compare(t1.distanceToLocationSqr((class_1937)level, location), t2.distanceToLocationSqr((class_1937)level, location))).limit(5L).toList();
        if (trainCount > 0 && !nearestTrains.isEmpty()) {
            chat.accept("Nearest Trains: ", 16756064);
            chat.accept("", white);
            for (Train train : nearestTrains) {
                GlobalStation currentStation;
                chat.accept(String.format("\u252c%1$s: %2$s, %3$d Wagons", train.id.toString().substring(0, 5), train.name.getString(), train.carriages.size()), 0xFFEFEF);
                if (train.derailed) {
                    chat.accept("\u251c\u2500Derailed", 16756064);
                } else if (train.graph != null) {
                    chat.accept("\u251c\u2500On Track: " + train.graph.id.toString().substring(0, 5), 11192544);
                }
                class_1309 owner = train.getOwner((class_1937)level);
                if (owner != null) {
                    chat.accept("\u251c\u2500Owned by " + owner.method_5477().getString(), 11192544);
                }
                if ((currentStation = train.getCurrentStation()) != null) {
                    chat.accept("\u251c\u2500Waiting at: " + currentStation.name, 11192544);
                } else if (train.navigation.destination != null) {
                    chat.accept("\u251c\u2500Travelling to " + train.navigation.destination.name + " (" + class_3532.method_15357((double)train.navigation.distanceToDestination) + "m away)", 8955319);
                }
                ScheduleRuntime runtime = train.runtime;
                if (runtime.getSchedule() != null) {
                    chat.accept("\u251c\u2500Schedule, Entry " + runtime.currentEntry + ", " + (runtime.paused ? "Paused" : runtime.state.name().replaceAll("_", " ")), runtime.paused ? 8955319 : 11192544);
                } else {
                    chat.accept("\u251c\u2500Idle, No Schedule", 8955319);
                }
                List<class_5321<class_1937>> presentDimensions = train.getPresentDimensions();
                if (presentDimensions.size() > 1) {
                    chat.accept("\u251c\u2500Travelling between Dimensions:", 7046804);
                }
                presentDimensions.forEach(key -> chat.accept("\u251c\u2500In %1$s near [%2$s]".formatted(key.method_29177(), train.getPositionInDimension((class_5321<class_1937>)key).get().method_23854()), 7046804));
                chatRaw.accept(DumpRailwaysCommand.createTeleportButton(train));
                chatRaw.accept(DumpRailwaysCommand.createDeleteButton(train));
                chat.accept("", white);
            }
            if (trainCount > 5) {
                chat.accept("[...]", white);
                chat.accept("", white);
            }
        }
        chat.accept("-+--------------------------------+-", white);
    }

    private static class_2561 createDeleteButton(Train train) {
        return class_2561.method_43470((String)"\u2514\u2500").method_27694(style -> style.method_36139(11192544)).method_10852((class_2561)class_2564.method_10885((class_2561)class_2561.method_43470((String)"Remove").method_27694(style -> style.method_36139(16756064))).method_27694(style -> style.method_36139(11192544).method_10958(new class_2558(class_2558.class_2559.field_11750, "/c train remove " + train.id.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to remove ").method_10852(train.name)))));
    }

    private static class_2561 createTeleportButton(Train train) {
        return class_2561.method_43470((String)"\u251c\u2500").method_27694(style -> style.method_36139(8955319)).method_10852((class_2561)class_2564.method_10885((class_2561)class_2561.method_43470((String)"Teleport").method_27694(style -> style.method_36139(16756064))).method_27694(style -> style.method_36139(8955319).method_10958(new class_2558(class_2558.class_2559.field_11750, "/c train tp " + train.id.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to teleport to ").method_10852(train.name)))));
    }
}

