/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.fluid;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.simibubi.create.foundation.fluid.FluidHelper;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public abstract class FluidIngredient
implements Predicate<FluidStack> {
    public static final FluidIngredient EMPTY = new FluidStackIngredient();
    public List<FluidStack> matchingFluidStacks;
    protected long amountRequired;

    public static FluidIngredient fromTag(class_6862<class_3611> tag, long amount) {
        FluidTagIngredient ingredient = new FluidTagIngredient();
        ingredient.tag = tag;
        ingredient.amountRequired = amount;
        return ingredient;
    }

    public static FluidIngredient fromFluid(class_3611 fluid, long amount) {
        FluidStackIngredient ingredient = new FluidStackIngredient();
        ingredient.fluid = fluid;
        ingredient.amountRequired = amount;
        ingredient.fixFlowing();
        return ingredient;
    }

    public static FluidIngredient fromFluidStack(FluidStack fluidStack) {
        FluidStackIngredient ingredient = new FluidStackIngredient();
        ingredient.fluid = fluidStack.getFluid();
        ingredient.amountRequired = fluidStack.getAmount();
        ingredient.fixFlowing();
        if (fluidStack.hasTag()) {
            ingredient.tagToMatch = fluidStack.getTag();
        }
        return ingredient;
    }

    protected abstract boolean testInternal(FluidStack var1);

    protected abstract void readInternal(class_2540 var1);

    protected abstract void writeInternal(class_2540 var1);

    protected abstract void readInternal(JsonObject var1);

    protected abstract void writeInternal(JsonObject var1);

    protected abstract List<FluidStack> determineMatchingFluidStacks();

    public long getRequiredAmount() {
        return this.amountRequired;
    }

    public List<FluidStack> getMatchingFluidStacks() {
        if (this.matchingFluidStacks != null) {
            return this.matchingFluidStacks;
        }
        this.matchingFluidStacks = this.determineMatchingFluidStacks();
        return this.matchingFluidStacks;
    }

    @Override
    public boolean test(FluidStack t) {
        if (t == null) {
            throw new IllegalArgumentException("FluidStack cannot be null");
        }
        return this.testInternal(t);
    }

    public void write(class_2540 buffer) {
        buffer.writeBoolean(this instanceof FluidTagIngredient);
        buffer.method_10791(this.amountRequired);
        this.writeInternal(buffer);
    }

    public static FluidIngredient read(class_2540 buffer) {
        boolean isTagIngredient = buffer.readBoolean();
        FluidIngredient ingredient = isTagIngredient ? new FluidTagIngredient() : new FluidStackIngredient();
        ingredient.amountRequired = buffer.method_10816();
        ingredient.readInternal(buffer);
        return ingredient;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        this.writeInternal(json);
        json.addProperty("amount", (Number)this.amountRequired);
        return json;
    }

    public static boolean isFluidIngredient(@Nullable JsonElement je) {
        if (je == null || je.isJsonNull()) {
            return false;
        }
        if (!je.isJsonObject()) {
            return false;
        }
        JsonObject json = je.getAsJsonObject();
        if (json.has("fluidTag")) {
            return true;
        }
        return json.has("fluid");
    }

    public static FluidIngredient deserialize(@Nullable JsonElement je) {
        if (!FluidIngredient.isFluidIngredient(je)) {
            throw new JsonSyntaxException("Invalid fluid ingredient: " + String.valueOf(je));
        }
        JsonObject json = je.getAsJsonObject();
        FluidIngredient ingredient = json.has("fluidTag") ? new FluidTagIngredient() : new FluidStackIngredient();
        ingredient.readInternal(json);
        if (!json.has("amount")) {
            throw new JsonSyntaxException("Fluid ingredient has to define an amount");
        }
        ingredient.amountRequired = class_3518.method_15260((JsonObject)json, (String)"amount");
        return ingredient;
    }

    public static class FluidTagIngredient
    extends FluidIngredient {
        protected class_6862<class_3611> tag;

        @Override
        protected boolean testInternal(FluidStack t) {
            if (this.tag != null) {
                return FluidHelper.isTag(t, this.tag);
            }
            for (FluidStack accepted : this.getMatchingFluidStacks()) {
                if (!FluidHelper.isSame(accepted, t)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void readInternal(class_2540 buffer) {
            int size = buffer.method_10816();
            this.matchingFluidStacks = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.matchingFluidStacks.add(FluidStack.readFromPacket((class_2540)buffer));
            }
        }

        @Override
        protected void writeInternal(class_2540 buffer) {
            List<FluidStack> matchingFluidStacks = this.getMatchingFluidStacks();
            buffer.method_10804(matchingFluidStacks.size());
            matchingFluidStacks.stream().forEach(stack -> stack.writeToPacket(buffer));
        }

        @Override
        protected void readInternal(JsonObject json) {
            class_2960 name = new class_2960(class_3518.method_15265((JsonObject)json, (String)"fluidTag"));
            this.tag = class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)name);
        }

        @Override
        protected void writeInternal(JsonObject json) {
            json.addProperty("fluidTag", this.tag.comp_327().toString());
        }

        @Override
        protected List<FluidStack> determineMatchingFluidStacks() {
            return class_7923.field_41173.method_40266(this.tag).stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).map(f -> {
                if (f instanceof class_3609) {
                    return ((class_3609)f).method_15751();
                }
                return f;
            }).distinct().map(f -> new FluidStack(f, this.amountRequired)).collect(Collectors.toList());
        }
    }

    public static class FluidStackIngredient
    extends FluidIngredient {
        protected class_3611 fluid;
        protected class_2487 tagToMatch = new class_2487();

        void fixFlowing() {
            if (this.fluid instanceof class_3609) {
                this.fluid = ((class_3609)this.fluid).method_15751();
            }
        }

        @Override
        protected boolean testInternal(FluidStack t) {
            if (!FluidHelper.isSame(t, this.fluid)) {
                return false;
            }
            if (this.tagToMatch.method_33133()) {
                return true;
            }
            class_2487 tag = t.getOrCreateTag();
            return tag.method_10553().method_10543(this.tagToMatch).equals((Object)tag);
        }

        @Override
        protected void readInternal(class_2540 buffer) {
            this.fluid = (class_3611)buffer.method_42064((class_2359)class_7923.field_41173);
            this.tagToMatch = buffer.method_10798();
        }

        @Override
        protected void writeInternal(class_2540 buffer) {
            buffer.method_42065((class_2359)class_7923.field_41173, (Object)this.fluid);
            buffer.method_10794(this.tagToMatch);
        }

        @Override
        protected void readInternal(JsonObject json) {
            FluidStack stack = FluidHelper.deserializeFluidStack(json);
            this.fluid = stack.getFluid();
            this.tagToMatch = stack.getOrCreateTag();
        }

        @Override
        protected void writeInternal(JsonObject json) {
            json.addProperty("fluid", CatnipServices.REGISTRIES.getKeyOrThrow(this.fluid).toString());
            json.add("nbt", JsonParser.parseString((String)this.tagToMatch.toString()));
        }

        @Override
        protected List<FluidStack> determineMatchingFluidStacks() {
            return ImmutableList.of((Object)(this.tagToMatch.method_33133() ? new FluidStack(this.fluid, this.amountRequired) : new FluidStack(this.fluid, this.amountRequired, this.tagToMatch)));
        }
    }
}

