/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity;

import com.simibubi.create.api.event.BlockEntityBehaviourEvent;
import com.simibubi.create.api.schematic.nbt.PartialSafeNBT;
import com.simibubi.create.api.schematic.requirement.SpecialBlockEntityItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.CachedRenderBBBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import io.github.fabricators_of_create.porting_lib.block.ChunkUnloadListeningBlockEntity;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.createmod.ponder.api.VirtualBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class SmartBlockEntity
extends CachedRenderBBBlockEntity
implements PartialSafeNBT,
IInteractionChecker,
SpecialBlockEntityItemRequirement,
VirtualBlockEntity,
ChunkUnloadListeningBlockEntity {
    private final Map<BehaviourType<?>, BlockEntityBehaviour> behaviours = new Reference2ObjectArrayMap();
    private boolean initialized = false;
    private boolean firstNbtRead = true;
    protected int lazyTickRate;
    protected int lazyTickCounter;
    private boolean chunkUnloaded;
    private boolean virtualMode;

    public SmartBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        ArrayList<BlockEntityBehaviour> list = new ArrayList<BlockEntityBehaviour>();
        this.addBehaviours(list);
        list.forEach(b -> this.behaviours.put(b.getType(), (BlockEntityBehaviour)b));
    }

    public abstract void addBehaviours(List<BlockEntityBehaviour> var1);

    public void addBehavioursDeferred(List<BlockEntityBehaviour> behaviours) {
    }

    public void initialize() {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            ((BlockEntityBehaviourEvent.Callback)BlockEntityBehaviourEvent.EVENT.invoker()).manageBehaviors(new BlockEntityBehaviourEvent(this, this.behaviours));
        }
        this.forEachBehaviour(BlockEntityBehaviour::initialize);
        this.lazyTick();
    }

    public void tick() {
        if (!this.initialized && this.method_11002()) {
            this.initialize();
            this.initialized = true;
        }
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
        this.forEachBehaviour(BlockEntityBehaviour::tick);
    }

    public void lazyTick() {
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.method_11007(tag);
        this.forEachBehaviour(tb -> tb.write(tag, clientPacket));
    }

    @Override
    public void writeSafe(class_2487 tag) {
        super.method_11007(tag);
        this.forEachBehaviour(tb -> {
            if (tb.isSafeNBT()) {
                tb.writeSafe(tag);
            }
        });
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            ArrayList<BlockEntityBehaviour> list = new ArrayList<BlockEntityBehaviour>();
            this.addBehavioursDeferred(list);
            list.forEach(b -> this.behaviours.put(b.getType(), (BlockEntityBehaviour)b));
            ((BlockEntityBehaviourEvent.Callback)BlockEntityBehaviourEvent.EVENT.invoker()).manageBehaviors(new BlockEntityBehaviourEvent(this, this.behaviours));
        }
        super.method_11014(tag);
        this.forEachBehaviour(tb -> tb.read(tag, clientPacket));
    }

    public final void method_11014(class_2487 tag) {
        this.read(tag, false);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkUnloaded = true;
    }

    public final void method_11012() {
        super.method_11012();
        if (!this.chunkUnloaded) {
            this.remove();
        }
        this.invalidate();
    }

    public void invalidate() {
        this.forEachBehaviour(BlockEntityBehaviour::unload);
    }

    public void remove() {
    }

    public void destroy() {
        this.forEachBehaviour(BlockEntityBehaviour::destroy);
    }

    public final void method_11007(class_2487 tag) {
        this.write(tag, false);
    }

    @Override
    public final void readClient(class_2487 tag) {
        this.read(tag, true);
    }

    @Override
    public final class_2487 writeClient(class_2487 tag) {
        this.write(tag, true);
        return tag;
    }

    public <T extends BlockEntityBehaviour> T getBehaviour(BehaviourType<T> type) {
        return (T)this.behaviours.get(type);
    }

    public void forEachBehaviour(Consumer<BlockEntityBehaviour> action) {
        this.getAllBehaviours().forEach(action);
    }

    public Collection<BlockEntityBehaviour> getAllBehaviours() {
        return this.behaviours.values();
    }

    public void attachBehaviourLate(BlockEntityBehaviour behaviour) {
        this.behaviours.put(behaviour.getType(), behaviour);
        behaviour.blockEntity = this;
        behaviour.initialize();
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state) {
        return this.getAllBehaviours().stream().reduce(ItemRequirement.NONE, (r, b) -> r.union(b.getRequiredItems()), (r, r1) -> r.union((ItemRequirement)r1));
    }

    public void removeBehaviour(BehaviourType<?> type) {
        BlockEntityBehaviour remove = this.behaviours.remove(type);
        if (remove != null) {
            remove.unload();
        }
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void markVirtual() {
        this.virtualMode = true;
    }

    public boolean isVirtual() {
        return this.virtualMode;
    }

    public boolean isChunkUnloaded() {
        return this.chunkUnloaded;
    }

    @Override
    public boolean canPlayerUse(class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void sendToMenu(class_2540 buffer) {
        buffer.method_10807(this.method_11016());
        buffer.method_10794(this.method_16887());
    }

    public void refreshBlockState() {
        this.method_31664(this.method_10997().method_8320(this.method_11016()));
    }

    public void registerAwardables(List<BlockEntityBehaviour> behaviours, CreateAdvancement ... advancements) {
        for (BlockEntityBehaviour behaviour : behaviours) {
            if (!(behaviour instanceof AdvancementBehaviour)) continue;
            AdvancementBehaviour ab = (AdvancementBehaviour)behaviour;
            ab.add(advancements);
            return;
        }
        behaviours.add(new AdvancementBehaviour(this, advancements));
    }

    public void award(CreateAdvancement advancement) {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.awardPlayer(advancement);
        }
    }

    public void awardIfNear(CreateAdvancement advancement, int range) {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.awardPlayerIfNear(advancement, range);
        }
    }
}

