/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.observer;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalPropagator;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.UUID;
import net.createmod.catnip.data.Couple;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;

public class TrackObserver
extends SingleBlockEntityEdgePoint {
    private int activated = 0;
    private FilterItemStack filter = FilterItemStack.empty();
    private UUID currentTrain = null;

    @Override
    public void blockEntityAdded(class_2586 blockEntity, boolean front) {
        super.blockEntityAdded(blockEntity, front);
        FilteringBehaviour filteringBehaviour = BlockEntityBehaviour.get(blockEntity, FilteringBehaviour.TYPE);
        if (filteringBehaviour != null) {
            this.setFilterAndNotify(blockEntity.method_10997(), filteringBehaviour.getFilter());
        }
    }

    @Override
    public void tick(TrackGraph graph, boolean preTrains) {
        super.tick(graph, preTrains);
        if (this.isActivated()) {
            --this.activated;
        }
        if (!this.isActivated()) {
            this.currentTrain = null;
        }
    }

    public void setFilterAndNotify(class_1937 level, class_1799 filter) {
        this.filter = FilterItemStack.of(filter.method_7972());
        this.notifyTrains(level);
    }

    private void notifyTrains(class_1937 level) {
        TrackGraph graph = Create.RAILWAYS.sided((class_1936)level).getGraph((class_1936)level, (TrackNodeLocation)((Object)this.edgeLocation.getFirst()));
        if (graph == null) {
            return;
        }
        TrackEdge edge = graph.getConnection((Couple<TrackNode>)this.edgeLocation.map(graph::locateNode));
        if (edge == null) {
            return;
        }
        SignalPropagator.notifyTrains(graph, edge);
    }

    public FilterItemStack getFilter() {
        return this.filter;
    }

    public UUID getCurrentTrain() {
        return this.currentTrain;
    }

    public boolean isActivated() {
        return this.activated > 0;
    }

    public void keepAlive(Train train) {
        this.activated = 8;
        this.currentTrain = train.id;
    }

    @Override
    public void read(class_2487 nbt, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, migration, dimensions);
        this.activated = nbt.method_10550("Activated");
        this.filter = FilterItemStack.of(nbt.method_10562("Filter"));
        if (nbt.method_10545("TrainId")) {
            this.currentTrain = nbt.method_25926("TrainId");
        }
    }

    @Override
    public void read(class_2540 buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
    }

    @Override
    public void write(class_2487 nbt, DimensionPalette dimensions) {
        super.write(nbt, dimensions);
        nbt.method_10569("Activated", this.activated);
        nbt.method_10566("Filter", (class_2520)this.filter.serializeNBT());
        if (this.currentTrain != null) {
            nbt.method_25927("TrainId", this.currentTrain);
        }
    }

    @Override
    public void write(class_2540 buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
    }
}

