/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7923;

public class TrainPacket
extends SimplePacketBase {
    UUID trainId;
    Train train;
    boolean add;

    public TrainPacket(Train train, boolean add) {
        this.train = train;
        this.add = add;
    }

    public TrainPacket(class_2540 buffer) {
        int i;
        this.add = buffer.readBoolean();
        this.trainId = buffer.method_10790();
        if (!this.add) {
            return;
        }
        UUID owner = null;
        if (buffer.readBoolean()) {
            owner = buffer.method_10790();
        }
        ArrayList<Carriage> carriages = new ArrayList<Carriage>();
        ArrayList<Integer> carriageSpacing = new ArrayList<Integer>();
        int size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            Couple bogies = Couple.create(null, null);
            for (boolean isFirst : Iterate.trueAndFalse) {
                if (!isFirst && !buffer.readBoolean()) continue;
                AbstractBogeyBlock type = (AbstractBogeyBlock)class_7923.field_41175.method_10223(buffer.method_10810());
                boolean upsideDown = buffer.readBoolean();
                class_2487 data = buffer.method_10798();
                bogies.set(isFirst, (Object)new CarriageBogey(type, upsideDown, data, new TravellingPoint(), new TravellingPoint()));
            }
            int spacing = buffer.method_10816();
            carriages.add(new Carriage((CarriageBogey)bogies.getFirst(), (CarriageBogey)bogies.getSecond(), spacing));
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            carriageSpacing.add(buffer.method_10816());
        }
        boolean doubleEnded = buffer.readBoolean();
        this.train = new Train(this.trainId, owner, null, carriages, carriageSpacing, doubleEnded);
        this.train.name = class_2561.class_2562.method_10877((String)buffer.method_19772());
        this.train.icon = TrainIconType.byId(buffer.method_10810());
        this.train.mapColorIndex = buffer.method_10816();
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.writeBoolean(this.add);
        buffer.method_10797(this.train.id);
        if (!this.add) {
            return;
        }
        buffer.writeBoolean(this.train.owner != null);
        if (this.train.owner != null) {
            buffer.method_10797(this.train.owner);
        }
        buffer.method_10804(this.train.carriages.size());
        for (Carriage carriage : this.train.carriages) {
            for (boolean first : Iterate.trueAndFalse) {
                if (!first) {
                    boolean onTwoBogeys = carriage.isOnTwoBogeys();
                    buffer.writeBoolean(onTwoBogeys);
                    if (!onTwoBogeys) continue;
                }
                CarriageBogey bogey = (CarriageBogey)carriage.bogeys.get(first);
                buffer.method_10812(CatnipServices.REGISTRIES.getKeyOrThrow(bogey.type));
                buffer.writeBoolean(bogey.upsideDown);
                buffer.method_10794(bogey.bogeyData);
            }
            buffer.method_10804(carriage.bogeySpacing);
        }
        buffer.method_10804(this.train.carriageSpacing.size());
        this.train.carriageSpacing.forEach(arg_0 -> ((class_2540)buffer).method_10804(arg_0));
        buffer.writeBoolean(this.train.doubleEnded);
        buffer.method_10814(class_2561.class_2562.method_10867((class_2561)this.train.name));
        buffer.method_10812(this.train.icon.id);
        buffer.method_10804(this.train.mapColorIndex);
    }

    @Override
    public boolean handle(SimplePacketBase.Context context) {
        context.enqueueWork(() -> {
            Map<UUID, Train> trains = CreateClient.RAILWAYS.trains;
            if (this.add) {
                trains.put(this.train.id, this.train);
            } else {
                trains.remove(this.trainId);
            }
        });
        return true;
    }
}

