/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packager;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.api.packager.unpacking.UnpackingHandler;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.compat.computercraft.events.PackageEvent;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.crate.BottomlessItemHandler;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packager.PackagerBlock;
import com.simibubi.create.content.logistics.packager.PackagerItemHandler;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlock;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.simibubi.create.content.logistics.packagerLink.WiFiEffectPacket;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.util.StorageProvider;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.BlockFace;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_8242;
import org.jetbrains.annotations.Nullable;

public class PackagerBlockEntity
extends SmartBlockEntity
implements SidedStorageBlockEntity {
    public boolean redstonePowered;
    public int buttonCooldown;
    public String signBasedAddress;
    public InvManipulationBehaviour targetInventory;
    public class_1799 heldBox;
    public class_1799 previouslyUnwrapped;
    public List<BigItemStack> queuedExitingPackages;
    public PackagerItemHandler inventory;
    public static final int CYCLE = 20;
    public int animationTicks;
    public boolean animationInward;
    public AbstractComputerBehaviour computerBehaviour;
    public Boolean hasCustomComputerAddress;
    public String customComputerAddress;
    private InventorySummary availableItems;
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    private AdvancementBehaviour advancements;

    public PackagerBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.redstonePowered = state.method_28500((class_2769)PackagerBlock.POWERED).orElse(false);
        this.heldBox = class_1799.field_8037;
        this.previouslyUnwrapped = class_1799.field_8037;
        this.inventory = new PackagerItemHandler(this);
        this.animationTicks = 0;
        this.animationInward = true;
        this.queuedExitingPackages = new LinkedList<BigItemStack>();
        this.signBasedAddress = "";
        this.customComputerAddress = "";
        this.hasCustomComputerAddress = false;
        this.buttonCooldown = 0;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.targetInventory = (InvManipulationBehaviour)new InvManipulationBehaviour(this, CapManipulationBehaviourBase.InterfaceProvider.oppositeOfBlockFacing()).withFilter(this::supportsBlockEntity);
        behaviours.add(this.targetInventory);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
        this.advancements = new AdvancementBehaviour(this, AllAdvancements.PACKAGER);
        behaviours.add(this.advancements);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    private boolean supportsBlockEntity(Storage<ItemVariant> storage, StorageProvider<ItemVariant> provider) {
        return !(provider.findBlockEntity() instanceof PortableStorageInterfaceBlockEntity);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.recheckIfLinksPresent();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.buttonCooldown > 0) {
            --this.buttonCooldown;
        }
        if (this.animationTicks == 0) {
            this.previouslyUnwrapped = class_1799.field_8037;
            if (!this.field_11863.method_8608() && !this.queuedExitingPackages.isEmpty() && this.heldBox.method_7960()) {
                BigItemStack entry = this.queuedExitingPackages.get(0);
                this.heldBox = entry.stack.method_7972();
                --entry.count;
                if (entry.count <= 0) {
                    this.queuedExitingPackages.remove(0);
                }
                this.animationInward = false;
                this.animationTicks = 20;
                this.notifyUpdate();
            }
            return;
        }
        if (this.field_11863.field_9236) {
            if (this.animationTicks == 20 - (this.animationInward ? 5 : 1)) {
                AllSoundEvents.PACKAGER.playAt(this.field_11863, (class_2382)this.field_11867, 1.0f, 1.0f, true);
            }
            if (this.animationTicks == (this.animationInward ? 1 : 5)) {
                this.field_11863.method_45446(this.field_11867, class_3417.field_15131, class_3419.field_15245, 0.25f, 0.75f, true);
            }
        }
        --this.animationTicks;
        if (this.animationTicks == 0 && !this.field_11863.method_8608()) {
            this.wakeTheFrogs();
            this.method_5431();
        }
    }

    public void scheduleStockCheck() {
        Objects.requireNonNull(this.field_11863);
        this.field_11863.method_39279(this.field_11867, this.method_11010().method_26204(), 1);
    }

    public void triggerStockCheck() {
        this.getAvailableItems();
    }

    public InventorySummary getAvailableItems() {
        return this.getAvailableItems(false);
    }

    public InventorySummary getAvailableItems(boolean scanInputSlots) {
        if (this.availableItems != null && this.invVersionTracker.stillWaiting(this.targetInventory.getInventory())) {
            return this.availableItems;
        }
        InventorySummary availableItems = new InventorySummary();
        Storage targetInv = this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            this.availableItems = availableItems;
            return availableItems;
        }
        if (targetInv instanceof BottomlessItemHandler) {
            BottomlessItemHandler bih = (BottomlessItemHandler)targetInv;
            availableItems.add(bih.getStackInSlot(0), 1000000000);
            this.availableItems = availableItems;
            return availableItems;
        }
        try (Transaction t = Transaction.openOuter();){
            for (StorageView view : targetInv.nonEmptyViews()) {
                ItemVariant resource = (ItemVariant)view.getResource();
                long amount = scanInputSlots ? view.getAmount() : view.extract((Object)resource, view.getAmount(), (TransactionContext)t);
                availableItems.add(resource, amount);
            }
        }
        this.invVersionTracker.awaitNewVersion(this.targetInventory.getInventory());
        this.submitNewArrivals(this.availableItems, availableItems);
        this.availableItems = availableItems;
        return availableItems;
    }

    private void submitNewArrivals(InventorySummary before, InventorySummary after) {
        if (before == null || after.isEmpty()) {
            return;
        }
        HashSet<RequestPromiseQueue> promiseQueues = new HashSet<RequestPromiseQueue>();
        for (class_2350 d : Iterate.directions) {
            Object object;
            if (!this.field_11863.method_8477(this.field_11867.method_10093(d))) continue;
            class_2680 adjacentState = this.field_11863.method_8320(this.field_11867.method_10093(d));
            if (AllBlocks.FACTORY_GAUGE.has(adjacentState)) {
                if (FactoryPanelBlock.connectedDirection(adjacentState) != d || !((object = this.field_11863.method_8321(this.field_11867.method_10093(d))) instanceof FactoryPanelBlockEntity)) continue;
                FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)object;
                if (!fpbe.restocker) continue;
                object = fpbe.panels.values().iterator();
                while (object.hasNext()) {
                    FactoryPanelBehaviour behaviour = (FactoryPanelBehaviour)object.next();
                    if (!behaviour.isActive()) continue;
                    promiseQueues.add(behaviour.restockerPromises);
                }
            }
            if (!AllBlocks.STOCK_LINK.has(adjacentState) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d || !((object = this.field_11863.method_8321(this.field_11867.method_10093(d))) instanceof PackagerLinkBlockEntity)) continue;
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)object;
            UUID freqId = plbe.behaviour.freqId;
            if (!Create.LOGISTICS.hasQueuedPromises(freqId)) continue;
            promiseQueues.add(Create.LOGISTICS.getQueuedPromises(freqId));
        }
        if (promiseQueues.isEmpty()) {
            return;
        }
        for (BigItemStack entry : after.getStacks()) {
            before.add(entry.stack, -entry.count);
        }
        for (RequestPromiseQueue queue : promiseQueues) {
            for (BigItemStack entry : before.getStacks()) {
                if (entry.count >= 0) continue;
                queue.itemEnteredSystem(entry.stack, -entry.count);
            }
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.method_8608()) {
            return;
        }
        this.recheckIfLinksPresent();
        if (!this.redstonePowered) {
            return;
        }
        this.redstonePowered = this.method_11010().method_28500((class_2769)PackagerBlock.POWERED).orElse(false);
        if (!this.redstoneModeActive()) {
            return;
        }
        this.updateSignAddress();
        this.attemptToSend(null);
    }

    public void recheckIfLinksPresent() {
        boolean isLinked;
        if (this.field_11863.method_8608()) {
            return;
        }
        class_2680 blockState = this.method_11010();
        if (!blockState.method_28498((class_2769)PackagerBlock.LINKED)) {
            return;
        }
        boolean shouldBeLinked = this.getLinkPos() != null;
        if (shouldBeLinked == (isLinked = ((Boolean)blockState.method_11654((class_2769)PackagerBlock.LINKED)).booleanValue())) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_28493((class_2769)PackagerBlock.LINKED));
    }

    public boolean redstoneModeActive() {
        return this.method_11010().method_28500((class_2769)PackagerBlock.LINKED).orElse(false) == false;
    }

    private class_2338 getLinkPos() {
        for (class_2350 d : Iterate.directions) {
            class_2680 adjacentState = this.field_11863.method_8320(this.field_11867.method_10093(d));
            if (!AllBlocks.STOCK_LINK.has(adjacentState) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d) continue;
            return this.field_11867.method_10093(d);
        }
        return null;
    }

    public void flashLink() {
        for (class_2350 d : Iterate.directions) {
            class_2680 adjacentState = this.field_11863.method_8320(this.field_11867.method_10093(d));
            if (!AllBlocks.STOCK_LINK.has(adjacentState) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d) continue;
            WiFiEffectPacket.send(this.field_11863, this.field_11867.method_10093(d));
            return;
        }
    }

    public boolean isTooBusyFor(LogisticallyLinkedBehaviour.RequestType type) {
        int queue = this.queuedExitingPackages.size();
        return queue >= (switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case LogisticallyLinkedBehaviour.RequestType.PLAYER -> 50;
            case LogisticallyLinkedBehaviour.RequestType.REDSTONE -> 20;
            case LogisticallyLinkedBehaviour.RequestType.RESTOCK -> 10;
        });
    }

    public void activate() {
        this.redstonePowered = true;
        this.method_5431();
        this.recheckIfLinksPresent();
        if (!this.redstoneModeActive()) {
            return;
        }
        this.updateSignAddress();
        this.attemptToSend(null);
        if (this.buttonCooldown <= 0) {
            this.buttonCooldown = 40;
        }
    }

    public boolean unwrapBox(class_1799 box, TransactionContext ctx) {
        if (this.animationTicks > 0) {
            return false;
        }
        Objects.requireNonNull(this.field_11863);
        ItemStackHandler contents = PackageItem.getContents(box);
        List<class_1799> items = ItemHelper.getNonEmptyStacks(contents);
        if (items.isEmpty()) {
            return true;
        }
        PackageOrderWithCrafts orderContext = PackageItem.getOrderContext(box);
        class_2350 facing = this.method_11010().method_28500((class_2769)PackagerBlock.field_10927).orElse(class_2350.field_11036);
        class_2338 target = this.field_11867.method_10093(facing.method_10153());
        class_2680 targetState = this.field_11863.method_8320(target);
        UnpackingHandler handler = UnpackingHandler.REGISTRY.get((class_2688<class_2248, ?>)targetState);
        UnpackingHandler toUse = handler != null ? handler : UnpackingHandler.DEFAULT;
        boolean unpacked = toUse.unpack(this.field_11863, target, targetState, facing, items, orderContext, ctx);
        if (unpacked) {
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
                this.computerBehaviour.prepareComputerEvent(new PackageEvent(box, "package_received"));
                this.previouslyUnwrapped = box;
                this.animationInward = true;
                this.animationTicks = 20;
                this.notifyUpdate();
            });
        }
        return unpacked;
    }

    public void attemptToSend(List<PackagingRequest> queuedRequests) {
        class_2586 class_25862;
        boolean requestQueue;
        if (!(queuedRequests != null || this.heldBox.method_7960() && this.animationTicks == 0 && this.buttonCooldown <= 0)) {
            return;
        }
        Storage targetInv = this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        boolean anyItemPresent = false;
        ItemStackHandler extractedItems = new ItemStackHandler(9);
        class_1799 extractedPackageItem = class_1799.field_8037;
        PackagingRequest nextRequest = null;
        String fixedAddress = null;
        int fixedOrderId = 0;
        int linkIndexInOrder = 0;
        boolean finalLinkInOrder = false;
        int packageIndexAtLink = 0;
        boolean finalPackageAtLink = false;
        PackageOrderWithCrafts orderContext = null;
        boolean bl = requestQueue = queuedRequests != null;
        if (requestQueue && !queuedRequests.isEmpty()) {
            nextRequest = queuedRequests.get(0);
            fixedAddress = nextRequest.address();
            fixedOrderId = nextRequest.orderId();
            linkIndexInOrder = nextRequest.linkIndex();
            finalLinkInOrder = nextRequest.finalLink().booleanValue();
            packageIndexAtLink = nextRequest.packageCounter().getAndIncrement();
            orderContext = nextRequest.context();
        }
        block14: for (int i = 0; i < 9; ++i) {
            boolean continuePacking = true;
            block15: while (continuePacking) {
                continuePacking = false;
                for (StorageView view : targetInv.nonEmptyViews()) {
                    Transaction t = Transaction.openOuter();
                    try {
                        long inserted;
                        int initialCount;
                        long extractedAmount;
                        boolean bulky;
                        ItemVariant resource = (ItemVariant)view.getResource();
                        boolean bl2 = bulky = !resource.getItem().method_31568();
                        if (bulky && anyItemPresent || (extractedAmount = view.extract((Object)resource, (long)(initialCount = requestQueue ? Math.min(64, nextRequest.getCount()) : 64), (TransactionContext)t)) == 0L) continue;
                        class_1799 extracted = resource.toStack((int)extractedAmount);
                        if (requestQueue && !ItemHandlerHelper.canItemStacksStack((class_1799)extracted, (class_1799)nextRequest.item()) || (inserted = extractedItems.insert(resource, extractedAmount, (TransactionContext)t)) != extractedAmount) continue;
                        anyItemPresent = true;
                        t.commit();
                        if (extracted.method_7909() instanceof PackageItem) {
                            extractedPackageItem = extracted;
                        }
                        if (!requestQueue) {
                            if (!bulky) continue;
                            break block14;
                        }
                        nextRequest.subtract((int)inserted);
                        if (!nextRequest.isEmpty()) {
                            if (!bulky) continue;
                            break block14;
                        }
                        finalPackageAtLink = true;
                        queuedRequests.remove(0);
                        if (queuedRequests.isEmpty()) break block14;
                        int previousCount = nextRequest.packageCounter().intValue();
                        nextRequest = queuedRequests.get(0);
                        if (!fixedAddress.equals(nextRequest.address()) || fixedOrderId != nextRequest.orderId()) break block14;
                        nextRequest.packageCounter().setValue(previousCount);
                        finalPackageAtLink = false;
                        continuePacking = true;
                        if (nextRequest.context() != null) {
                            orderContext = nextRequest.context();
                        }
                        if (!bulky) continue block15;
                        break block14;
                    }
                    finally {
                        if (t == null) continue;
                        t.close();
                    }
                }
            }
        }
        if (!anyItemPresent) {
            if (nextRequest != null) {
                queuedRequests.remove(0);
            }
            return;
        }
        class_1799 createdBox = extractedPackageItem.method_7960() ? PackageItem.containing(extractedItems) : extractedPackageItem.method_7972();
        this.computerBehaviour.prepareComputerEvent(new PackageEvent(createdBox, "package_created"));
        PackageItem.clearAddress(createdBox);
        if (fixedAddress != null) {
            PackageItem.addAddress(createdBox, fixedAddress);
        }
        if (requestQueue) {
            PackageItem.setOrder(createdBox, fixedOrderId, linkIndexInOrder, finalLinkInOrder, packageIndexAtLink, finalPackageAtLink, orderContext);
        }
        if (!requestQueue && !this.signBasedAddress.isBlank()) {
            PackageItem.addAddress(createdBox, this.signBasedAddress);
        }
        class_2338 linkPos = this.getLinkPos();
        if (extractedPackageItem.method_7960() && linkPos != null && (class_25862 = this.field_11863.method_8321(linkPos)) instanceof PackagerLinkBlockEntity) {
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)class_25862;
            plbe.behaviour.deductFromAccurateSummary(extractedItems);
        }
        if (!this.heldBox.method_7960() || this.animationTicks != 0) {
            this.queuedExitingPackages.add(new BigItemStack(createdBox, 1));
            return;
        }
        this.heldBox = createdBox;
        this.animationInward = false;
        this.animationTicks = 20;
        this.advancements.awardPlayer(AllAdvancements.PACKAGER);
        this.triggerStockCheck();
        this.notifyUpdate();
    }

    public void updateSignAddress() {
        this.signBasedAddress = "";
        for (class_2350 side : Iterate.directions) {
            String address = this.getSign(side);
            if (address == null || address.isBlank()) continue;
            this.signBasedAddress = address;
        }
        if (this.computerBehaviour.hasAttachedComputer() && this.hasCustomComputerAddress.booleanValue()) {
            this.signBasedAddress = this.customComputerAddress;
        } else {
            this.hasCustomComputerAddress = false;
        }
    }

    protected String getSign(class_2350 side) {
        class_2586 blockEntity = this.field_11863.method_8321(this.field_11867.method_10093(side));
        if (!(blockEntity instanceof class_2625)) {
            return null;
        }
        class_2625 sign = (class_2625)blockEntity;
        for (boolean front : Iterate.trueAndFalse) {
            class_8242 text = sign.method_49843(front);
            Object address = "";
            for (class_2561 component : text.method_49877(false)) {
                String string = component.getString();
                if (string.isBlank()) continue;
                address = (String)address + string.trim() + " ";
            }
            if (((String)address).isBlank()) continue;
            return ((String)address).trim();
        }
        return null;
    }

    protected void wakeTheFrogs() {
        class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10093(class_2350.field_11036));
        if (class_25862 instanceof FrogportBlockEntity) {
            FrogportBlockEntity port = (FrogportBlockEntity)class_25862;
            port.tryPullingFromOwnAndAdjacentInventories();
        }
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.redstonePowered = compound.method_10577("Active");
        this.animationInward = compound.method_10577("AnimationInward");
        this.animationTicks = compound.method_10550("AnimationTicks");
        this.signBasedAddress = compound.method_10558("SignAddress");
        this.customComputerAddress = compound.method_10558("ComputerAddress");
        this.hasCustomComputerAddress = compound.method_10577("HasComputerAddress");
        this.heldBox = class_1799.method_7915((class_2487)compound.method_10562("HeldBox"));
        this.previouslyUnwrapped = class_1799.method_7915((class_2487)compound.method_10562("InsertedBox"));
        if (clientPacket) {
            return;
        }
        this.queuedExitingPackages = NBTHelper.readCompoundList((class_2499)compound.method_10554("QueuedExitingPackages", 10), BigItemStack::read);
        if (compound.method_10545("LastSummary")) {
            this.availableItems = InventorySummary.read(compound.method_10562("LastSummary"));
        }
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10556("Active", this.redstonePowered);
        compound.method_10556("AnimationInward", this.animationInward);
        compound.method_10569("AnimationTicks", this.animationTicks);
        compound.method_10582("SignAddress", this.signBasedAddress);
        compound.method_10582("ComputerAddress", this.customComputerAddress);
        compound.method_10556("HasComputerAddress", this.hasCustomComputerAddress.booleanValue());
        compound.method_10566("HeldBox", this.heldBox.serializeNBT());
        compound.method_10566("InsertedBox", this.previouslyUnwrapped.serializeNBT());
        if (clientPacket) {
            return;
        }
        compound.method_10566("QueuedExitingPackages", (class_2520)NBTHelper.writeCompoundList(this.queuedExitingPackages, BigItemStack::write));
        if (this.availableItems != null) {
            compound.method_10566("LastSummary", (class_2520)this.availableItems.write());
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        ItemHelper.dropContents(this.field_11863, this.field_11867, (Storage<ItemVariant>)this.inventory);
        this.queuedExitingPackages.forEach(bigStack -> {
            for (int i = 0; i < bigStack.count; ++i) {
                class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)bigStack.stack.method_7972());
            }
        });
        this.queuedExitingPackages.clear();
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 side) {
        return this.inventory;
    }

    public float getTrayOffset(float partialTicks) {
        float tickCycle = this.animationInward ? (float)this.animationTicks - partialTicks : (float)(this.animationTicks - 5) - partialTicks;
        float progress = class_3532.method_15363((float)(tickCycle / 15.0f * 2.0f - 1.0f), (float)-1.0f, (float)1.0f);
        progress = 1.0f - progress * progress;
        return progress * progress;
    }

    public class_1799 getRenderedBox() {
        if (this.animationInward) {
            return this.animationTicks <= 10 ? class_1799.field_8037 : this.previouslyUnwrapped;
        }
        return this.animationTicks >= 10 ? class_1799.field_8037 : this.heldBox;
    }

    public boolean isTargetingSameInventory(@Nullable IdentifiedInventory inventory) {
        if (inventory == null) {
            return false;
        }
        Storage targetHandler = this.targetInventory.getInventory();
        if (targetHandler == null) {
            return false;
        }
        if (inventory.identifier() != null) {
            BlockFace face = this.targetInventory.getTarget().getOpposite();
            return inventory.identifier().contains(face);
        }
        return false;
    }
}

