/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidContentsAttribute
implements ItemAttribute {
    @Nullable
    private class_3611 fluid;

    public FluidContentsAttribute(@Nullable class_3611 fluid) {
        this.fluid = fluid;
    }

    private static List<class_3611> extractFluids(class_1799 stack) {
        Storage storage = (Storage)ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM);
        if (storage == null) {
            return List.of();
        }
        ArrayList<class_3611> fluids = new ArrayList<class_3611>();
        for (StorageView view : storage.nonEmptyViews()) {
            fluids.add(((FluidVariant)view.getResource()).getFluid());
        }
        return fluids;
    }

    @Override
    public boolean appliesTo(class_1799 itemStack, class_1937 level) {
        return FluidContentsAttribute.extractFluids(itemStack).contains(this.fluid);
    }

    @Override
    public String getTranslationKey() {
        return "has_fluid";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.fluid != null) {
            parameter = this.fluid.getFluidType().getDescription().getString();
        }
        return new Object[]{parameter};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.HAS_FLUID;
    }

    @Override
    public void save(class_2487 nbt) {
        if (this.fluid == null) {
            return;
        }
        Optional<class_2960> id = class_7923.field_41173.method_29113((Object)this.fluid).map(class_5321::method_29177);
        if (id.isEmpty()) {
            return;
        }
        nbt.method_10582("fluidId", id.toString());
    }

    @Override
    public void load(class_2487 nbt) {
        if (nbt.method_10545("fluidId")) {
            this.fluid = (class_3611)class_7923.field_41173.method_10223(class_2960.method_12829((String)nbt.method_10558("fluidId")));
        }
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new FluidContentsAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            for (class_3611 fluid : FluidContentsAttribute.extractFluids(stack)) {
                list.add(new FluidContentsAttribute(fluid));
            }
            return list;
        }
    }
}

