/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt;

import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Map;
import net.createmod.catnip.math.VecHelper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3532;

public class BeltHelper {
    public static Map<class_1792, Boolean> uprightCache = new Object2BooleanOpenHashMap();
    public static final IdentifiableResourceReloadListener LISTENER = new SimpleSynchronousResourceReloadListener(){

        public class_2960 getFabricId() {
            return Create.asResource("belt_helper");
        }

        public void method_14491(class_3300 resourceManager) {
            uprightCache.clear();
        }
    };

    public static boolean isItemUpright(class_1799 stack) {
        return uprightCache.computeIfAbsent(stack.method_7909(), item -> {
            boolean isFluidHandler = ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM) != null;
            boolean useUpright = AllTags.AllItemTags.UPRIGHT_ON_BELT.matches(stack);
            boolean forceDisableUpright = !AllTags.AllItemTags.NOT_UPRIGHT_ON_BELT.matches(stack);
            return (isFluidHandler || useUpright) && forceDisableUpright;
        });
    }

    public static BeltBlockEntity getSegmentBE(class_1936 world, class_2338 pos) {
        class_1937 l;
        if (world instanceof class_1937 && !(l = (class_1937)world).method_8477(pos)) {
            return null;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof BeltBlockEntity)) {
            return null;
        }
        return (BeltBlockEntity)blockEntity;
    }

    public static BeltBlockEntity getControllerBE(class_1936 world, class_2338 pos) {
        BeltBlockEntity segment = BeltHelper.getSegmentBE(world, pos);
        if (segment == null) {
            return null;
        }
        class_2338 controllerPos = segment.controller;
        if (controllerPos == null) {
            return null;
        }
        return BeltHelper.getSegmentBE(world, controllerPos);
    }

    public static BeltBlockEntity getBeltForOffset(BeltBlockEntity controller, float offset) {
        return BeltHelper.getBeltAtSegment(controller, (int)Math.floor(offset));
    }

    public static BeltBlockEntity getBeltAtSegment(BeltBlockEntity controller, int segment) {
        class_2338 pos = BeltHelper.getPositionForOffset(controller, segment);
        class_2586 be = controller.method_10997().method_8321(pos);
        if (be == null || !(be instanceof BeltBlockEntity)) {
            return null;
        }
        return (BeltBlockEntity)be;
    }

    public static class_2338 getPositionForOffset(BeltBlockEntity controller, int offset) {
        class_2338 pos = controller.method_11016();
        class_2382 vec = controller.getBeltFacing().method_10163();
        BeltSlope slope = (BeltSlope)((Object)controller.method_11010().method_11654(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        return pos.method_10069(offset * vec.method_10263(), class_3532.method_15340((int)offset, (int)0, (int)(controller.beltLength - 1)) * verticality, offset * vec.method_10260());
    }

    public static class_243 getVectorForOffset(BeltBlockEntity controller, float offset) {
        BeltSlope slope = (BeltSlope)((Object)controller.method_11010().method_11654(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        float verticalMovement = verticality;
        if ((double)offset < 0.5) {
            verticalMovement = 0.0f;
        }
        verticalMovement *= Math.min(offset, (float)controller.beltLength - 0.5f) - 0.5f;
        class_243 vec = VecHelper.getCenterOf((class_2382)controller.method_11016());
        class_243 horizontalMovement = class_243.method_24954((class_2382)controller.getBeltFacing().method_10163()).method_1021((double)(offset - 0.5f));
        if (slope == BeltSlope.VERTICAL) {
            horizontalMovement = class_243.field_1353;
        }
        vec = vec.method_1019(horizontalMovement).method_1031(0.0, (double)verticalMovement, 0.0);
        return vec;
    }

    public static class_243 getBeltVector(class_2680 state) {
        BeltSlope slope = (BeltSlope)((Object)state.method_11654(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        class_243 horizontalMovement = class_243.method_24954((class_2382)((class_2350)state.method_11654(BeltBlock.HORIZONTAL_FACING)).method_10163());
        if (slope == BeltSlope.VERTICAL) {
            return new class_243(0.0, (double)((class_2350)state.method_11654(BeltBlock.HORIZONTAL_FACING)).method_10171().method_10181(), 0.0);
        }
        return new class_243(0.0, (double)verticality, 0.0).method_1019(horizontalMovement);
    }
}

