/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.base;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.equipment.armor.BacktankRenderer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import com.simibubi.create.infrastructure.fabric.SimpleBlockEntityVisualFactory;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import java.util.function.Consumer;
import net.createmod.catnip.theme.Color;
import net.minecraft.class_2350;
import net.minecraft.class_2382;

public class SingleAxisRotatingVisual<T extends KineticBlockEntity>
extends KineticBlockEntityVisual<T>
implements SimpleTickableVisual {
    public static boolean rainbowMode = false;
    protected final RotatingInstance rotatingModel;

    public SingleAxisRotatingVisual(VisualizationContext context, T blockEntity, float partialTick, Model model) {
        this(context, blockEntity, partialTick, class_2350.field_11036, model);
    }

    public SingleAxisRotatingVisual(VisualizationContext context, T blockEntity, float partialTick, class_2350 from, Model model) {
        super(context, blockEntity, partialTick);
        this.rotatingModel = ((RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, model).createInstance()).rotateToFace(from, this.rotationAxis()).setup((KineticBlockEntity)blockEntity).setPosition((class_2382)this.getVisualPosition());
        this.rotatingModel.setChanged();
    }

    public static <T extends KineticBlockEntity> SimpleBlockEntityVisualFactory<T> of(PartialModel partial) {
        return (context, blockEntity, partialTick) -> new SingleAxisRotatingVisual<KineticBlockEntity>(context, (KineticBlockEntity)blockEntity, partialTick, Models.partial((PartialModel)partial));
    }

    public static <T extends KineticBlockEntity> SimpleBlockEntityVisualFactory<T> ofZ(PartialModel partial) {
        return (context, blockEntity, partialTick) -> new SingleAxisRotatingVisual<KineticBlockEntity>(context, (KineticBlockEntity)blockEntity, partialTick, class_2350.field_11035, Models.partial((PartialModel)partial));
    }

    public static <T extends KineticBlockEntity> SingleAxisRotatingVisual<T> shaft(VisualizationContext context, T blockEntity, float partialTick) {
        return new SingleAxisRotatingVisual<T>(context, blockEntity, partialTick, Models.partial((PartialModel)AllPartialModels.SHAFT));
    }

    public static <T extends KineticBlockEntity> SingleAxisRotatingVisual<T> backtank(VisualizationContext context, T blockEntity, float partialTick) {
        Model model = Models.partial((PartialModel)BacktankRenderer.getShaftModel(blockEntity.method_11010()));
        return new SingleAxisRotatingVisual<T>(context, blockEntity, partialTick, model);
    }

    public void update(float pt) {
        this.rotatingModel.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    public void tick(TickableVisual.Context context) {
        float overStressedEffect = ((KineticBlockEntity)this.blockEntity).effects.overStressedEffect;
        if (overStressedEffect != 0.0f) {
            boolean overstressed = overStressedEffect > 0.0f;
            Color color = overstressed ? Color.RED : Color.SPRING_GREEN;
            float weight = overstressed ? overStressedEffect : -overStressedEffect;
            this.rotatingModel.setColor(Color.WHITE.mixWith(color, weight));
        } else {
            this.rotatingModel.setColor(Color.WHITE);
        }
        this.rotatingModel.setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.rotatingModel});
    }

    protected void _delete() {
        this.rotatingModel.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.rotatingModel);
    }
}

