/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Arrays;
import java.util.function.Supplier;
import net.createmod.catnip.data.Iterate;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;

public class PipeAttachmentModel
extends ForwardingBakedModel {
    private boolean ao;

    public static PipeAttachmentModel withAO(class_1087 template) {
        return new PipeAttachmentModel(template, true);
    }

    public static PipeAttachmentModel withoutAO(class_1087 template) {
        return new PipeAttachmentModel(template, false);
    }

    public PipeAttachmentModel(class_1087 template, boolean ao) {
        this.wrapped = template;
        this.ao = ao;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 world, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        PipeModelData data = new PipeModelData();
        BracketedBlockEntityBehaviour bracket = BlockEntityBehaviour.get((class_1922)world, pos, BracketedBlockEntityBehaviour.TYPE);
        Object object = world.getBlockEntityRenderData(pos);
        if (object instanceof FluidTransportBehaviour.AttachmentTypes[]) {
            FluidTransportBehaviour.AttachmentTypes[] attachments = (FluidTransportBehaviour.AttachmentTypes[])object;
            for (int i = 0; i < attachments.length; ++i) {
                data.putAttachment(Iterate.directions[i], attachments[i]);
            }
        }
        if (bracket != null) {
            data.putBracket(bracket.getBracket());
        }
        data.setEncased(FluidPipeBlock.shouldDrawCasing(world, pos, state));
        super.emitBlockQuads(world, state, pos, randomSupplier, context);
        this.addQuads(world, state, pos, randomSupplier, context, data);
    }

    private void addQuads(class_1920 world, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context, PipeModelData pipeData) {
        class_1087 bracket = pipeData.getBracket();
        if (bracket != null) {
            bracket.emitBlockQuads(world, state, pos, randomSupplier, context);
        }
        for (class_2350 d : Iterate.directions) {
            FluidTransportBehaviour.AttachmentTypes type = pipeData.getAttachment(d);
            for (FluidTransportBehaviour.AttachmentTypes.ComponentPartials partial : type.partials) {
                AllPartialModels.PIPE_ATTACHMENTS.get((Object)partial).get(d).get().emitBlockQuads(world, state, pos, randomSupplier, context);
            }
        }
        if (pipeData.isEncased()) {
            AllPartialModels.FLUID_PIPE_CASING.get().emitBlockQuads(world, state, pos, randomSupplier, context);
        }
    }

    public boolean method_4708() {
        return this.ao;
    }

    private static class PipeModelData {
        private FluidTransportBehaviour.AttachmentTypes[] attachments = new FluidTransportBehaviour.AttachmentTypes[6];
        private boolean encased;
        private class_1087 bracket;

        public PipeModelData() {
            Arrays.fill((Object[])this.attachments, (Object)FluidTransportBehaviour.AttachmentTypes.NONE);
        }

        public void putBracket(class_2680 state) {
            if (state != null) {
                this.bracket = class_310.method_1551().method_1541().method_3349(state);
            }
        }

        public class_1087 getBracket() {
            return this.bracket;
        }

        public void putAttachment(class_2350 face, FluidTransportBehaviour.AttachmentTypes rim) {
            this.attachments[face.method_10146()] = rim;
        }

        public FluidTransportBehaviour.AttachmentTypes getAttachment(class_2350 face) {
            return this.attachments[face.method_10146()];
        }

        public void setEncased(boolean encased) {
            this.encased = encased;
        }

        public boolean isEncased() {
            return this.encased;
        }
    }
}

