/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.minecart.capability;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.minecart.CouplingHandler;
import com.simibubi.create.content.contraptions.minecart.capability.MinecartController;
import io.github.fabricators_of_create.porting_lib.core.util.INBTSerializable;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.WorldAttached;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1688;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2818;

public class CapabilityMinecartController
implements INBTSerializable<class_2487> {
    public static WorldAttached<Map<UUID, MinecartController>> loadedMinecartsByUUID = new WorldAttached($ -> new HashMap());
    public static WorldAttached<Set<UUID>> loadedMinecartsWithCoupling = new WorldAttached($ -> new HashSet());
    static WorldAttached<List<class_1688>> queuedAdditions = new WorldAttached($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));
    static WorldAttached<List<UUID>> queuedUnloads = new WorldAttached($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));

    public static void tick(class_1937 world) {
        MinecartController controller;
        Map carts = (Map)loadedMinecartsByUUID.get((class_1936)world);
        List queued = (List)queuedAdditions.get((class_1936)world);
        List queuedRemovals = (List)queuedUnloads.get((class_1936)world);
        Set cartsWithCoupling = (Set)loadedMinecartsWithCoupling.get((class_1936)world);
        Set keySet = carts.keySet();
        for (UUID removal : queuedRemovals) {
            keySet.remove(removal);
            cartsWithCoupling.remove(removal);
        }
        for (class_1688 cart : queued) {
            class_1688 minecartEntity;
            MinecartController minecartController;
            UUID uniqueID = cart.method_5667();
            if (world.field_9236 && carts.containsKey(uniqueID) && (minecartController = (MinecartController)carts.get(uniqueID)) != null && (minecartEntity = minecartController.cart()) != null && minecartEntity.method_5628() != cart.method_5628()) continue;
            cartsWithCoupling.remove(uniqueID);
            controller = cart.create$getController();
            carts.put(uniqueID, controller);
            if (controller.isLeadingCoupling()) {
                cartsWithCoupling.add(uniqueID);
            }
            if (world.field_9236 || controller == null) continue;
            controller.sendData();
        }
        queuedRemovals.clear();
        queued.clear();
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry entry : carts.entrySet()) {
            controller = (MinecartController)entry.getValue();
            if (controller != null && controller.isPresent()) {
                controller.tick();
                continue;
            }
            toRemove.add((UUID)entry.getKey());
        }
        for (UUID uuid : toRemove) {
            keySet.remove(uuid);
            cartsWithCoupling.remove(uuid);
        }
    }

    public static void onChunkUnloaded(class_1937 world, class_2818 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        Map carts = (Map)loadedMinecartsByUUID.get((class_1936)world);
        for (MinecartController minecartController : carts.values()) {
            class_1688 cart;
            if (minecartController == null || !minecartController.isPresent() || !(cart = minecartController.cart()).method_31476().equals((Object)chunkPos)) continue;
            ((List)queuedUnloads.get((class_1936)world)).add(cart.method_5667());
        }
    }

    public static void onCartRemoved(class_1937 world, class_1688 entity) {
        Map carts = (Map)loadedMinecartsByUUID.get((class_1936)world);
        List unloads = (List)queuedUnloads.get((class_1936)world);
        UUID uniqueID = entity.method_5667();
        if (!carts.containsKey(uniqueID) || unloads.contains(uniqueID)) {
            return;
        }
        if (world.field_9236) {
            return;
        }
        CapabilityMinecartController.handleKilledMinecart(world, (MinecartController)carts.get(uniqueID), entity.method_19538());
    }

    protected static void handleKilledMinecart(class_1937 world, MinecartController controller, class_243 removedPos) {
        if (controller == null) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            class_1688 cart;
            MinecartController next = CouplingHandler.getNextInCouplingChain(world, controller, forward);
            if (next == null || next == MinecartController.EMPTY) continue;
            next.removeConnection(!forward);
            if (controller.hasContraptionCoupling(forward) || (cart = next.cart()) == null) continue;
            class_243 itemPos = cart.method_19538().method_1019(removedPos).method_1021(0.5);
            class_1542 itemEntity = new class_1542(world, itemPos.field_1352, itemPos.field_1351, itemPos.field_1350, AllItems.MINECART_COUPLING.asStack());
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
        }
    }

    @Nullable
    public static MinecartController getIfPresent(class_1937 world, UUID cartId) {
        Map carts = (Map)loadedMinecartsByUUID.get((class_1936)world);
        if (carts == null) {
            return null;
        }
        if (!carts.containsKey(cartId)) {
            return null;
        }
        return (MinecartController)carts.get(cartId);
    }

    public static void attach(class_1688 entity) {
        ((List)queuedAdditions.get((class_1936)entity.method_5770())).add(entity);
    }

    public static void startTracking(class_1297 entity) {
        if (!(entity instanceof class_1688)) {
            return;
        }
        class_1688 cart = (class_1688)entity;
        cart.create$getController().sendData();
    }
}

