/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlock;
import com.simibubi.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class ElevatorContactBlockEntity
extends SmartBlockEntity {
    public DoorControlBehaviour doorControls;
    public ElevatorColumn.ColumnCoords columnCoords;
    public boolean activateBlock;
    public String shortName = "";
    public String longName = "";
    public String lastReportedCurrentFloor = "";
    private int yTargetFromNBT = Integer.MIN_VALUE;
    private boolean deferNameGenerator = false;

    public ElevatorContactBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.doorControls = new DoorControlBehaviour(this);
        behaviours.add(this.doorControls);
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10582("ShortName", this.shortName);
        tag.method_10582("LongName", this.longName);
        if (this.lastReportedCurrentFloor != null) {
            tag.method_10582("LastReportedCurrentFloor", this.lastReportedCurrentFloor);
        }
        if (clientPacket) {
            return;
        }
        tag.method_10556("Activate", this.activateBlock);
        if (this.columnCoords == null) {
            return;
        }
        ElevatorColumn column = ElevatorColumn.get((class_1936)this.field_11863, this.columnCoords);
        if (column == null) {
            return;
        }
        tag.method_10569("ColumnTarget", column.getTargetedYLevel());
        if (column.isActive()) {
            NBTHelper.putMarker((class_2487)tag, (String)"ColumnActive");
        }
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.shortName = tag.method_10558("ShortName");
        this.longName = tag.method_10558("LongName");
        if (tag.method_10545("LastReportedCurrentFloor")) {
            this.lastReportedCurrentFloor = tag.method_10558("LastReportedCurrentFloor");
        }
        if (clientPacket) {
            return;
        }
        this.activateBlock = tag.method_10577("Activate");
        if (!tag.method_10545("ColumnTarget")) {
            return;
        }
        int target = tag.method_10550("ColumnTarget");
        boolean active = tag.method_10545("ColumnActive");
        if (this.columnCoords == null) {
            this.yTargetFromNBT = target;
            return;
        }
        ElevatorColumn column = ElevatorColumn.getOrCreate((class_1936)this.field_11863, this.columnCoords);
        column.target(target);
        column.setActive(active);
    }

    public void updateDisplayedFloor(String floor) {
        if (floor.equals(this.lastReportedCurrentFloor)) {
            return;
        }
        this.lastReportedCurrentFloor = floor;
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_11863.method_8608()) {
            return;
        }
        this.columnCoords = ElevatorContactBlock.getColumnCoords((class_1936)this.field_11863, this.field_11867);
        if (this.columnCoords == null) {
            return;
        }
        ElevatorColumn column = ElevatorColumn.getOrCreate((class_1936)this.field_11863, this.columnCoords);
        column.add(this.field_11867);
        if (this.shortName.isBlank()) {
            this.deferNameGenerator = true;
        }
        if (this.yTargetFromNBT == Integer.MIN_VALUE) {
            return;
        }
        column.target(this.yTargetFromNBT);
        this.yTargetFromNBT = Integer.MIN_VALUE;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.deferNameGenerator) {
            return;
        }
        if (this.columnCoords != null) {
            ElevatorColumn.getOrCreate((class_1936)this.field_11863, this.columnCoords).initNames(this.field_11863);
        }
        this.deferNameGenerator = false;
    }

    @Override
    public void invalidate() {
        ElevatorColumn column;
        if (this.columnCoords != null && (column = ElevatorColumn.get((class_1936)this.field_11863, this.columnCoords)) != null) {
            column.remove(this.field_11867);
        }
        super.invalidate();
    }

    public void updateName(String shortName, String longName) {
        this.shortName = shortName;
        this.longName = longName;
        this.deferNameGenerator = false;
        this.notifyUpdate();
        ElevatorColumn column = ElevatorColumn.get((class_1936)this.field_11863, this.columnCoords);
        if (column != null) {
            column.namesChanged();
        }
    }

    public Couple<String> getNames() {
        return Couple.create((Object)this.shortName, (Object)this.longName);
    }
}

