/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedCrafter;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3955;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class MechanicalCraftingCategory
extends CreateRecipeCategory<class_3955> {
    private final AnimatedCrafter crafter = new AnimatedCrafter();
    static int maxSize = 100;

    public MechanicalCraftingCategory(CreateRecipeCategory.Info<class_3955> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, class_3955 recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 134, 81).addItemStack(MechanicalCraftingCategory.getResultItem(recipe));
        int x = MechanicalCraftingCategory.getXPadding(recipe);
        int y = MechanicalCraftingCategory.getYPadding(recipe);
        float scale = MechanicalCraftingCategory.getScale(recipe);
        CrafterIngredientRenderer renderer = new CrafterIngredientRenderer(recipe);
        int i = 0;
        for (class_1856 ingredient : recipe.method_8117()) {
            float f = 19.0f * scale;
            int xPosition = (int)((float)(x + 1) + (float)(i % MechanicalCraftingCategory.getWidth(recipe)) * f);
            int yPosition = (int)((float)(y + 1) + (float)(i / MechanicalCraftingCategory.getWidth(recipe)) * f);
            builder.addSlot(RecipeIngredientRole.INPUT, xPosition, yPosition).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)renderer).addIngredients(ingredient);
            ++i;
        }
    }

    public static float getScale(class_3955 recipe) {
        int w = MechanicalCraftingCategory.getWidth(recipe);
        int h = MechanicalCraftingCategory.getHeight(recipe);
        return Math.min(1.0f, (float)maxSize / (19.0f * (float)Math.max(w, h)));
    }

    public static int getYPadding(class_3955 recipe) {
        return 53 - (int)((double)(MechanicalCraftingCategory.getScale(recipe) * (float)MechanicalCraftingCategory.getHeight(recipe) * 19.0f) * 0.5);
    }

    public static int getXPadding(class_3955 recipe) {
        return 53 - (int)((double)(MechanicalCraftingCategory.getScale(recipe) * (float)MechanicalCraftingCategory.getWidth(recipe) * 19.0f) * 0.5);
    }

    private static int getWidth(class_3955 recipe) {
        return recipe instanceof class_1869 ? ((class_1869)recipe).method_8150() : 1;
    }

    private static int getHeight(class_3955 recipe) {
        return recipe instanceof class_1869 ? ((class_1869)recipe).method_8158() : 1;
    }

    public void draw(class_3955 recipe, IRecipeSlotsView iRecipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        class_4587 matrixStack = graphics.method_51448();
        matrixStack.method_22903();
        float scale = MechanicalCraftingCategory.getScale(recipe);
        matrixStack.method_46416((float)MechanicalCraftingCategory.getXPadding(recipe), (float)MechanicalCraftingCategory.getYPadding(recipe), 0.0f);
        for (int row = 0; row < MechanicalCraftingCategory.getHeight(recipe); ++row) {
            int pIndex;
            for (int col = 0; col < MechanicalCraftingCategory.getWidth(recipe) && (pIndex = row * MechanicalCraftingCategory.getWidth(recipe) + col) < recipe.method_8117().size(); ++col) {
                if (((class_1856)recipe.method_8117().get(pIndex)).method_8103()) continue;
                matrixStack.method_22903();
                matrixStack.method_46416((float)(col * 19) * scale, (float)(row * 19) * scale, 0.0f);
                matrixStack.method_22905(scale, scale, scale);
                AllGuiTextures.JEI_SLOT.render(graphics, 0, 0);
                matrixStack.method_22909();
            }
        }
        matrixStack.method_22909();
        AllGuiTextures.JEI_SLOT.render(graphics, 133, 80);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 128, 59);
        this.crafter.draw(graphics, 129, 25);
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, 0.0f, 300.0f);
        int amount = 0;
        for (class_1856 ingredient : recipe.method_8117()) {
            if (class_1856.field_9017 == ingredient) continue;
            ++amount;
        }
        graphics.method_25303(class_310.method_1551().field_1772, "" + amount, 142, 39, 0xFFFFFF);
        matrixStack.method_22909();
    }

    private static final class CrafterIngredientRenderer
    implements IIngredientRenderer<class_1799> {
        private final class_3955 recipe;
        private final float scale;

        public CrafterIngredientRenderer(class_3955 recipe) {
            this.recipe = recipe;
            this.scale = MechanicalCraftingCategory.getScale(recipe);
        }

        public void render(class_332 graphics, @NotNull class_1799 ingredient) {
            class_4587 matrixStack = graphics.method_51448();
            matrixStack.method_22903();
            float scale = MechanicalCraftingCategory.getScale(this.recipe);
            matrixStack.method_22905(scale, scale, scale);
            if (ingredient != null) {
                class_4587 modelViewStack = RenderSystem.getModelViewStack();
                modelViewStack.method_22903();
                RenderSystem.applyModelViewMatrix();
                RenderSystem.enableDepthTest();
                class_310 minecraft = class_310.method_1551();
                class_327 font = this.getFontRenderer(minecraft, ingredient);
                graphics.method_51427(ingredient, 0, 0);
                graphics.method_51432(font, ingredient, 0, 0, null);
                RenderSystem.disableBlend();
                modelViewStack.method_22909();
                RenderSystem.applyModelViewMatrix();
            }
            matrixStack.method_22909();
        }

        public int getWidth() {
            return (int)(16.0f * this.scale);
        }

        public int getHeight() {
            return (int)(16.0f * this.scale);
        }

        public List<class_2561> getTooltip(class_1799 ingredient, class_1836 tooltipFlag) {
            class_310 minecraft = class_310.method_1551();
            class_746 player = minecraft.field_1724;
            try {
                return ingredient.method_7950((class_1657)player, tooltipFlag);
            }
            catch (LinkageError | RuntimeException e) {
                ArrayList<class_2561> list = new ArrayList<class_2561>();
                class_5250 crash = class_2561.method_43471((String)"jei.tooltip.error.crash");
                list.add((class_2561)crash.method_27692(class_124.field_1061));
                return list;
            }
        }
    }
}

