/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.computercraft.implementation.luaObjects;

import com.simibubi.create.compat.computercraft.implementation.ComputerUtil;
import com.simibubi.create.compat.computercraft.implementation.luaObjects.LuaComparable;
import com.simibubi.create.compat.computercraft.implementation.luaObjects.LuaItemStack;
import com.simibubi.create.compat.computercraft.implementation.luaObjects.PackageOrderLuaObject;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;

public class PackageLuaObject
implements LuaComparable {
    public PackagerBlockEntity blockEntity;
    public class_1799 box;
    public String address;

    public PackageLuaObject(PackagerBlockEntity blockEntity, class_1799 box) {
        this.blockEntity = blockEntity;
        this.box = box;
        this.address = PackageItem.getAddress(box);
    }

    @LuaFunction(mainThread=true)
    public final boolean isEditable() {
        return this.blockEntity != null && !this.blockEntity.heldBox.method_7960() && this.blockEntity.heldBox == this.box;
    }

    @LuaFunction(mainThread=true)
    public final String getAddress() throws LuaException {
        if (this.isEditable()) {
            this.address = PackageItem.getAddress(this.box);
        }
        return this.address;
    }

    @LuaFunction(mainThread=true)
    public final void setAddress(String argument) throws LuaException {
        if (!this.isEditable()) {
            throw new LuaException("Package is not editable");
        }
        PackageItem.addAddress(this.box, argument);
        this.address = argument;
    }

    @LuaFunction(mainThread=true)
    public Map<Integer, Map<String, ?>> list() {
        return ComputerUtil.list((Storage<ItemVariant>)PackageItem.getContents(this.box));
    }

    @LuaFunction(mainThread=true)
    public Map<String, ?> getItemDetail(int slot) throws LuaException {
        return ComputerUtil.getItemDetail((Storage<ItemVariant>)PackageItem.getContents(this.box), slot);
    }

    public boolean hasOrderData() {
        return PackageItem.hasFragmentData(this.box);
    }

    @LuaFunction(mainThread=true)
    public final PackageOrderLuaObject getOrderData() throws LuaException {
        if (!this.hasOrderData()) {
            return null;
        }
        return new PackageOrderLuaObject(this);
    }

    public final List<LuaItemStack> getLuaItemStacks() {
        ItemStackHandler results = PackageItem.getContents(this.box);
        ArrayList<LuaItemStack> result = new ArrayList<LuaItemStack>();
        for (int i = 0; i < results.getSlotCount(); ++i) {
            class_1799 stack = results.getStackInSlot(i);
            if (stack.method_7960()) continue;
            result.add(new LuaItemStack(stack));
        }
        return result;
    }

    @Override
    public Map<?, ?> getTableRepresentation() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("address", this.getAddress());
            map.put("contents", this.getLuaItemStacks());
            if (this.hasOrderData()) {
                map.put("orderData", this.getOrderData());
            }
            return map;
        }
        catch (LuaException e) {
            return null;
        }
    }
}

