/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities;

import foundationgames.enhancedblockentities.EnhancedBlockEntityRegistry;
import foundationgames.enhancedblockentities.client.model.DynamicModelEffects;
import foundationgames.enhancedblockentities.client.model.DynamicModelProvider;
import foundationgames.enhancedblockentities.client.model.DynamicUnbakedModel;
import foundationgames.enhancedblockentities.client.model.ModelIdentifiers;
import foundationgames.enhancedblockentities.client.model.ModelSelector;
import foundationgames.enhancedblockentities.client.model.misc.DecoratedPotModelSelector;
import foundationgames.enhancedblockentities.client.render.BlockEntityRenderCondition;
import foundationgames.enhancedblockentities.client.render.BlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.BellBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.ChestBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.ShulkerBoxBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.SignBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.resource.EBEPack;
import foundationgames.enhancedblockentities.util.DateUtil;
import foundationgames.enhancedblockentities.util.EBEUtil;
import foundationgames.enhancedblockentities.util.ResourceUtil;
import foundationgames.enhancedblockentities.util.duck.BakedModelManagerAccess;
import java.util.function.Function;
import net.devtech.arrp.json.models.JModel;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.minecraft.class_1087;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2480;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public final class EBESetup
extends Enum<EBESetup> {
    private static final /* synthetic */ EBESetup[] $VALUES;

    public static EBESetup[] values() {
        return (EBESetup[])$VALUES.clone();
    }

    public static EBESetup valueOf(String name) {
        return Enum.valueOf(EBESetup.class, name);
    }

    public static void setupRRPChests() {
        EBEPack p = ResourceUtil.getPackForCompat();
        ResourceUtil.addChestBlockStates("chest", p);
        ResourceUtil.addChestBlockStates("trapped_chest", p);
        ResourceUtil.addChestBlockStates("christmas_chest", p);
        ResourceUtil.addSingleChestOnlyBlockStates("ender_chest", p);
        p = ResourceUtil.getBasePack();
        ResourceUtil.addSingleChestModels("entity/chest/normal", "chest", p);
        ResourceUtil.addDoubleChestModels("entity/chest/normal_left", "entity/chest/normal_right", "chest", p);
        ResourceUtil.addSingleChestModels("entity/chest/trapped", "trapped_chest", p);
        ResourceUtil.addDoubleChestModels("entity/chest/trapped_left", "entity/chest/trapped_right", "trapped_chest", p);
        ResourceUtil.addSingleChestModels("entity/chest/christmas", "christmas_chest", p);
        ResourceUtil.addDoubleChestModels("entity/chest/christmas_left", "entity/chest/christmas_right", "christmas_chest", p);
        ResourceUtil.addSingleChestModels("entity/chest/ender", "ender_chest", p);
        p.addResource(class_3264.field_14188, new class_2960("models/item/chest.json"), ResourceUtil.createChestItemModelResource("chest_center").getBytes());
        p.addResource(class_3264.field_14188, new class_2960("models/item/trapped_chest.json"), ResourceUtil.createChestItemModelResource("trapped_chest_center").getBytes());
        p.addModel(JModel.model((String)"block/ender_chest_center"), new class_2960("item/ender_chest"));
        p.addDirBlockSprites("entity/chest", "entity/chest/");
    }

    public static void setupRRPSigns() {
        EBEPack p = ResourceUtil.getPackForCompat();
        ResourceUtil.addSignBlockStates("oak_sign", "oak_wall_sign", p);
        ResourceUtil.addSignBlockStates("birch_sign", "birch_wall_sign", p);
        ResourceUtil.addSignBlockStates("spruce_sign", "spruce_wall_sign", p);
        ResourceUtil.addSignBlockStates("jungle_sign", "jungle_wall_sign", p);
        ResourceUtil.addSignBlockStates("acacia_sign", "acacia_wall_sign", p);
        ResourceUtil.addSignBlockStates("dark_oak_sign", "dark_oak_wall_sign", p);
        ResourceUtil.addSignBlockStates("mangrove_sign", "mangrove_wall_sign", p);
        ResourceUtil.addSignBlockStates("cherry_sign", "cherry_wall_sign", p);
        ResourceUtil.addSignBlockStates("crimson_sign", "crimson_wall_sign", p);
        ResourceUtil.addSignBlockStates("warped_sign", "warped_wall_sign", p);
        ResourceUtil.addSignBlockStates("bamboo_sign", "bamboo_wall_sign", p);
        ResourceUtil.addHangingSignBlockStates("oak_hanging_sign", "oak_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("birch_hanging_sign", "birch_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("spruce_hanging_sign", "spruce_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("jungle_hanging_sign", "jungle_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("acacia_hanging_sign", "acacia_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("dark_oak_hanging_sign", "dark_oak_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("mangrove_hanging_sign", "mangrove_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("cherry_hanging_sign", "cherry_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("crimson_hanging_sign", "crimson_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("warped_hanging_sign", "warped_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("bamboo_hanging_sign", "bamboo_wall_hanging_sign", p);
        p = ResourceUtil.getBasePack();
        ResourceUtil.addSignTypeModels("oak", p);
        ResourceUtil.addSignTypeModels("birch", p);
        ResourceUtil.addSignTypeModels("spruce", p);
        ResourceUtil.addSignTypeModels("jungle", p);
        ResourceUtil.addSignTypeModels("acacia", p);
        ResourceUtil.addSignTypeModels("dark_oak", p);
        ResourceUtil.addSignTypeModels("mangrove", p);
        ResourceUtil.addSignTypeModels("cherry", p);
        ResourceUtil.addSignTypeModels("crimson", p);
        ResourceUtil.addSignTypeModels("warped", p);
        ResourceUtil.addSignTypeModels("bamboo", p);
        p.addDirBlockSprites("entity/signs", "entity/signs/");
        p.addDirBlockSprites("entity/signs/hanging", "entity/signs/hanging/");
        p.addDirBlockSprites("gui/hanging_signs", "block/particle_hanging_sign_");
    }

    public static void setupRRPBells() {
        ResourceUtil.addBellBlockState(ResourceUtil.getPackForCompat());
        ResourceUtil.getBasePack().addSingleBlockSprite(new class_2960("entity/bell/bell_body"));
    }

    public static void setupRRPBeds() {
        EBEPack p = ResourceUtil.getBasePack();
        EBEPack pCompat = ResourceUtil.getPackForCompat();
        for (class_1767 color : class_1767.values()) {
            ResourceUtil.addBedBlockState(color, pCompat);
            ResourceUtil.addBedModels(color, p);
        }
        p.addDirBlockSprites("entity/bed", "entity/bed/");
    }

    public static void setupRRPShulkerBoxes() {
        EBEPack p = ResourceUtil.getBasePack();
        EBEPack pCompat = ResourceUtil.getPackForCompat();
        for (class_1767 color : EBEUtil.DEFAULTED_DYE_COLORS) {
            String id = color != null ? color.method_7792() + "_shulker_box" : "shulker_box";
            ResourceUtil.addShulkerBoxBlockStates(color, pCompat);
            ResourceUtil.addShulkerBoxModels(color, p);
            p.addModel(JModel.model((String)("block/" + id)), new class_2960("item/" + id));
        }
        p.addDirBlockSprites("entity/shulker", "entity/shulker/");
    }

    public static void setupRRPDecoratedPots() {
        EBEPack p = ResourceUtil.getBasePack();
        EBEPack pCompat = ResourceUtil.getPackForCompat();
        ResourceUtil.addDecoratedPotBlockState(pCompat);
        for (class_5321 patternKey : class_7923.field_42940.method_42021()) {
            ResourceUtil.addDecoratedPotPatternModels((class_5321<String>)patternKey, p);
        }
        p.addDirBlockSprites("entity/decorated_pot", "entity/decorated_pot/");
    }

    public static void setupResourceProviders() {
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "chest_center"), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.CHEST_CENTER, ModelIdentifiers.CHEST_CENTER_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_CENTER, ModelIdentifiers.CHRISTMAS_CHEST_CENTER_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "chest_left"), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.CHEST_LEFT, ModelIdentifiers.CHEST_LEFT_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_LEFT, ModelIdentifiers.CHRISTMAS_CHEST_LEFT_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "chest_right"), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.CHEST_RIGHT, ModelIdentifiers.CHEST_RIGHT_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_RIGHT, ModelIdentifiers.CHRISTMAS_CHEST_RIGHT_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "trapped_chest_center"), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.TRAPPED_CHEST_CENTER, ModelIdentifiers.TRAPPED_CHEST_CENTER_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_CENTER, ModelIdentifiers.CHRISTMAS_CHEST_CENTER_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "trapped_chest_left"), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.TRAPPED_CHEST_LEFT, ModelIdentifiers.TRAPPED_CHEST_LEFT_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_LEFT, ModelIdentifiers.CHRISTMAS_CHEST_LEFT_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "trapped_chest_right"), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.TRAPPED_CHEST_RIGHT, ModelIdentifiers.TRAPPED_CHEST_RIGHT_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_RIGHT, ModelIdentifiers.CHRISTMAS_CHEST_RIGHT_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "ender_chest_center"), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.ENDER_CHEST_CENTER, ModelIdentifiers.ENDER_CHEST_CENTER_TRUNK}, ModelSelector.CHEST, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "bell_between_walls"), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.BELL_BETWEEN_WALLS_WITH_BELL, ModelIdentifiers.BELL_BETWEEN_WALLS}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "bell_ceiling"), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.BELL_CEILING_WITH_BELL, ModelIdentifiers.BELL_CEILING}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "bell_floor"), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.BELL_FLOOR_WITH_BELL, ModelIdentifiers.BELL_FLOOR}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "bell_wall"), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.BELL_WALL_WITH_BELL, ModelIdentifiers.BELL_WALL}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        for (class_1767 color : EBEUtil.DEFAULTED_DYE_COLORS) {
            ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", (String)(color != null ? color.method_7792() + "_shulker_box" : "shulker_box")), () -> new DynamicUnbakedModel(new class_2960[]{ModelIdentifiers.SHULKER_BOXES.get(color), ModelIdentifiers.SHULKER_BOX_BOTTOMS.get(color)}, ModelSelector.SHULKER_BOX, DynamicModelEffects.SHULKER_BOX)));
        }
        DecoratedPotModelSelector decoratedPotSelector = new DecoratedPotModelSelector();
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new class_2960("builtin", "decorated_pot"), () -> new DynamicUnbakedModel(decoratedPotSelector.createModelIDs(), decoratedPotSelector, DynamicModelEffects.DECORATED_POT)));
    }

    public static void setupChests() {
        BlockRenderLayerMap.INSTANCE.putBlock(class_2246.field_10034, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(class_2246.field_10380, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(class_2246.field_10443, class_1921.method_23579());
        Function<class_2586, Integer> christmasChestSelector = entity -> {
            int os = DateUtil.isChristmas() ? 3 : 0;
            class_2745 type = (class_2745)entity.method_11010().method_11654((class_2769)class_2741.field_12506);
            return type == class_2745.field_12571 ? 2 + os : (type == class_2745.field_12574 ? 1 + os : os);
        };
        EnhancedBlockEntityRegistry.register(class_2246.field_10034, class_2591.field_11914, BlockEntityRenderCondition.CHEST, new ChestBlockEntityRendererOverride(() -> {
            BakedModelManagerAccess manager = (BakedModelManagerAccess)class_310.method_1551().method_1554();
            return new class_1087[]{manager.getModel(ModelIdentifiers.CHEST_CENTER_LID), manager.getModel(ModelIdentifiers.CHEST_LEFT_LID), manager.getModel(ModelIdentifiers.CHEST_RIGHT_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_CENTER_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_LEFT_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_RIGHT_LID)};
        }, christmasChestSelector));
        EnhancedBlockEntityRegistry.register(class_2246.field_10380, class_2591.field_11891, BlockEntityRenderCondition.CHEST, new ChestBlockEntityRendererOverride(() -> {
            BakedModelManagerAccess manager = (BakedModelManagerAccess)class_310.method_1551().method_1554();
            return new class_1087[]{manager.getModel(ModelIdentifiers.TRAPPED_CHEST_CENTER_LID), manager.getModel(ModelIdentifiers.TRAPPED_CHEST_LEFT_LID), manager.getModel(ModelIdentifiers.TRAPPED_CHEST_RIGHT_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_CENTER_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_LEFT_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_RIGHT_LID)};
        }, christmasChestSelector));
        EnhancedBlockEntityRegistry.register(class_2246.field_10443, class_2591.field_11901, BlockEntityRenderCondition.CHEST, new ChestBlockEntityRendererOverride(() -> {
            BakedModelManagerAccess manager = (BakedModelManagerAccess)class_310.method_1551().method_1554();
            return new class_1087[]{manager.getModel(ModelIdentifiers.ENDER_CHEST_CENTER_LID)};
        }, entity -> 0));
    }

    public static void setupSigns() {
        for (class_2248 sign : new class_2248[]{class_2246.field_10121, class_2246.field_10187, class_2246.field_10231, class_2246.field_10391, class_2246.field_10411, class_2246.field_10088, class_2246.field_10544, class_2246.field_10587, class_2246.field_10284, class_2246.field_10401, class_2246.field_10330, class_2246.field_10265, class_2246.field_37554, class_2246.field_37552, class_2246.field_42735, class_2246.field_42736, class_2246.field_22104, class_2246.field_22106, class_2246.field_22105, class_2246.field_22107, class_2246.field_40277, class_2246.field_40261}) {
            EnhancedBlockEntityRegistry.register(sign, class_2591.field_11911, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        }
        for (class_2248 sign : new class_2248[]{class_2246.field_40262, class_2246.field_40272, class_2246.field_40264, class_2246.field_40274, class_2246.field_40263, class_2246.field_40273, class_2246.field_40266, class_2246.field_40278, class_2246.field_40265, class_2246.field_40275, class_2246.field_40267, class_2246.field_40279, class_2246.field_40270, class_2246.field_40280, class_2246.field_42738, class_2246.field_42739, class_2246.field_40268, class_2246.field_40281, class_2246.field_40269, class_2246.field_40282, class_2246.field_40271, class_2246.field_40283}) {
            EnhancedBlockEntityRegistry.register(sign, class_2591.field_40330, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
            BlockRenderLayerMap.INSTANCE.putBlock(sign, class_1921.method_23581());
        }
    }

    public static void setupBells() {
        EnhancedBlockEntityRegistry.register(class_2246.field_16332, class_2591.field_16413, BlockEntityRenderCondition.BELL, new BellBlockEntityRendererOverride());
    }

    public static void setupBeds() {
        EnhancedBlockEntityRegistry.register(class_2246.field_10461, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10527, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10288, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10109, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10141, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10561, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10621, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10326, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10180, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10230, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10410, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10610, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10019, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10069, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10120, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(class_2246.field_10356, class_2591.field_11910, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
    }

    public static void setupShulkerBoxes() {
        for (class_1767 color : EBEUtil.DEFAULTED_DYE_COLORS) {
            class_2248 block = class_2480.method_10525((class_1767)color);
            BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23579());
            EnhancedBlockEntityRegistry.register(block, class_2591.field_11896, BlockEntityRenderCondition.SHULKER_BOX, new ShulkerBoxBlockEntityRendererOverride(map -> {
                BakedModelManagerAccess models = (BakedModelManagerAccess)class_310.method_1551().method_1554();
                for (class_1767 dc : EBEUtil.DEFAULTED_DYE_COLORS) {
                    map.put(dc, models.getModel(ModelIdentifiers.SHULKER_BOX_LIDS.get(dc)));
                }
            }));
        }
    }

    public static void setupDecoratedPots() {
        EnhancedBlockEntityRegistry.register(class_2246.field_42752, class_2591.field_42781, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
    }

    private static /* synthetic */ EBESetup[] $values() {
        return new EBESetup[0];
    }

    static {
        $VALUES = EBESetup.$values();
    }
}

