/*
 * Decompiled with CFR 0.152.
 */
package net.quarrymod.blockentity.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;

public final class SlotGroup<T extends MachineBaseBlockEntity> {
    private final RebornInventory<T> inventory;
    private final int[] slotList;

    public SlotGroup(RebornInventory<T> inventory, int[] slotList) {
        this.inventory = inventory;
        this.slotList = slotList;
    }

    private boolean hasSpace(int slot, class_1799 stack) {
        class_1799 slotStack = this.inventory.method_5438(slot);
        return slotStack.method_7960() || ItemUtils.isItemEqual((class_1799)slotStack, (class_1799)stack, (boolean)true, (boolean)true) && slotStack.method_7947() + stack.method_7947() <= stack.method_7914();
    }

    public boolean hasSpace(class_1799 stack) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        list.add(stack);
        return this.hasSpace(list);
    }

    public boolean hasSpace(List<class_1799> stacks) {
        for (class_1799 stack : stacks) {
            boolean canAdd = false;
            for (int slot : this.slotList) {
                if (!this.hasSpace(slot, stack)) continue;
                canAdd = true;
                break;
            }
            if (canAdd) continue;
            return false;
        }
        return true;
    }

    private void addStack(int slot, class_1799 stack) {
        class_1799 slotStack = this.inventory.method_5438(slot);
        if (slotStack.method_7960()) {
            this.inventory.method_5447(slot, stack);
        } else if (ItemUtils.isItemEqual((class_1799)slotStack, (class_1799)stack, (boolean)true, (boolean)true)) {
            slotStack.method_7939(Math.min(stack.method_7914(), stack.method_7947() + slotStack.method_7947()));
        }
    }

    public void addStack(class_1799 stack) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        list.add(stack);
        this.addStacks(list);
    }

    public void addStacks(List<class_1799> drops) {
        block0: for (class_1799 drop : drops) {
            for (int slotId : this.slotList) {
                if (!this.hasSpace(slotId, drop)) continue;
                this.addStack(slotId, drop);
                continue block0;
            }
        }
        this.inventory.setHashChanged();
    }

    public void consume(class_1799 stack) {
        class_1799 slotStack = this.getConsumeSlot(stack);
        slotStack.method_7939(slotStack.method_7947() - stack.method_7947());
    }

    public boolean canConsume(class_1799 stack) {
        return this.getConsumeSlot(stack) != null;
    }

    public void executeForAll(Consumer<class_1799> func) {
        for (int slotId : this.slotList) {
            func.accept(this.inventory.method_5438(slotId));
        }
    }

    public class_1799 consumeAny(int count, Predicate<class_1799> filter) {
        for (int slotId : this.slotList) {
            class_1799 slotStack = this.inventory.method_5438(slotId);
            if (slotStack.method_7960() || slotStack.method_7947() < count || !filter.test(slotStack)) continue;
            class_1799 consumeStack = slotStack.method_7972();
            consumeStack.method_7939(count);
            this.consume(consumeStack);
            return consumeStack;
        }
        return class_1799.field_8037;
    }

    private class_1799 getConsumeSlot(class_1799 stack) {
        for (int slotId : this.slotList) {
            class_1799 slotStack = this.inventory.method_5438(slotId);
            if (slotStack.method_7960() || !ItemUtils.isItemEqual((class_1799)slotStack, (class_1799)stack, (boolean)true, (boolean)true) || slotStack.method_7947() < stack.method_7947()) continue;
            return slotStack;
        }
        return null;
    }
}

