/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.disenchanter.catalyst;

import com.glisco.disenchanter.catalyst.Catalyst;
import com.glisco.disenchanter.catalyst.CatalystRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2499;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class Catalysts {
    public static void registerDefaults() {
        CatalystRegistry.registerFromConfig(class_1802.field_8687, new Emerald());
        CatalystRegistry.registerFromConfig(class_1802.field_8477, new Diamond());
        CatalystRegistry.registerFromConfig(class_1802.field_8634, new EnderPearl());
        CatalystRegistry.registerFromConfig(class_1802.field_8207, new HeartOfTheSea());
        CatalystRegistry.registerFromConfig(class_1802.field_27063, new AmethystShard());
        CatalystRegistry.registerFromConfig(class_1802.field_8137, new NetherStar());
        CatalystRegistry.registerFromConfig(class_1802.field_8287, new ExperienceBottle());
    }

    public static class Emerald
    implements Catalyst {
        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            Map levelMap = class_1890.method_22445((class_2499)input.method_7921());
            ArrayList enchantments = new ArrayList(levelMap.keySet());
            for (int i = 0; i < 2 && !enchantments.isEmpty(); ++i) {
                class_1887 addition = (class_1887)enchantments.remove(random.method_43048(enchantments.size()));
                class_1772.method_7807((class_1799)resultStack, (class_1889)new class_1889(addition, ((Integer)levelMap.get(addition)).intValue()));
            }
            return resultStack;
        }
    }

    public static class Diamond
    implements Catalyst {
        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            Map levelMap = class_1890.method_22445((class_2499)input.method_7921());
            ArrayList enchantments = new ArrayList(levelMap.keySet());
            class_1887 enchantment = (class_1887)enchantments.remove(0);
            class_1772.method_7807((class_1799)resultStack, (class_1889)new class_1889(enchantment, ((Integer)levelMap.get(enchantment)).intValue()));
            for (int i = 0; i < 2 && !enchantments.isEmpty(); ++i) {
                class_1887 adddition = (class_1887)enchantments.remove(random.method_43048(enchantments.size()));
                class_1772.method_7807((class_1799)resultStack, (class_1889)new class_1889(adddition, ((Integer)levelMap.get(adddition)).intValue()));
            }
            return resultStack;
        }
    }

    public static class EnderPearl
    implements Catalyst {
        @Nullable
        private class_1889 enchantmentCache = null;

        @Override
        public class_1799 transformInput(class_1799 input, class_5819 random) {
            input.method_7970(500, random, null);
            Map levelMap = class_1890.method_22445((class_2499)input.method_7921());
            ArrayList enchantments = new ArrayList(levelMap.keySet());
            class_1887 removedEnchantment = (class_1887)enchantments.remove(random.method_43048(enchantments.size()));
            this.enchantmentCache = new class_1889(removedEnchantment, ((Integer)levelMap.get(removedEnchantment)).intValue());
            levelMap.remove(removedEnchantment);
            class_1890.method_8214((Map)levelMap, (class_1799)input);
            return input;
        }

        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            if (this.enchantmentCache == null) {
                throw new IllegalStateException();
            }
            class_1772.method_7807((class_1799)resultStack, (class_1889)this.enchantmentCache);
            this.enchantmentCache = null;
            return resultStack;
        }
    }

    public static class HeartOfTheSea
    implements Catalyst {
        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            Map levelMap = class_1890.method_22445((class_2499)input.method_7921());
            levelMap.forEach((enchantment, integer) -> levelMap.replace(enchantment, Math.max(1, integer - 1)));
            levelMap.forEach((enchantment, integer) -> class_1772.method_7807((class_1799)resultStack, (class_1889)new class_1889(enchantment, integer.intValue())));
            return resultStack;
        }
    }

    public static class AmethystShard
    implements Catalyst {
        @Override
        public class_1799 transformInput(class_1799 input, class_5819 random) {
            class_1890.method_8214(new HashMap(), (class_1799)input);
            return input;
        }

        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            Map levelMap = class_1890.method_22445((class_2499)input.method_7921());
            class_1887 enchantment = (class_1887)levelMap.keySet().iterator().next();
            class_1772.method_7807((class_1799)resultStack, (class_1889)new class_1889(enchantment, ((Integer)levelMap.get(enchantment)).intValue()));
            return resultStack;
        }
    }

    public static class NetherStar
    implements Catalyst {
        @Override
        public class_1799 transformInput(class_1799 input, class_5819 random) {
            class_1890.method_8214(new HashMap(), (class_1799)input);
            return input;
        }

        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            Map levelMap = class_1890.method_22445((class_2499)input.method_7921());
            levelMap.forEach((enchantment, integer) -> class_1772.method_7807((class_1799)resultStack, (class_1889)new class_1889(enchantment, integer.intValue())));
            return resultStack;
        }
    }

    public static class ExperienceBottle
    implements Catalyst {
        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            Map levelMap = class_1890.method_22445((class_2499)input.method_7921());
            int maxLevel = levelMap.entrySet().stream().max((o1, o2) -> {
                if (Objects.equals(o1.getValue(), o2.getValue())) {
                    return 0;
                }
                return (Integer)o1.getValue() > (Integer)o2.getValue() ? 1 : -1;
            }).map(Map.Entry::getValue).orElse(-1);
            levelMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() == maxLevel).forEach(entry -> class_1772.method_7807((class_1799)resultStack, (class_1889)new class_1889((class_1887)entry.getKey(), ((Integer)entry.getValue()).intValue())));
            return resultStack;
        }
    }
}

