/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.disenchanter.catalyst;

import com.glisco.disenchanter.Disenchanter;
import com.glisco.disenchanter.catalyst.Catalyst;
import com.glisco.disenchanter.compat.config.DisenchanterConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_7923;

public final class CatalystRegistry {
    private static final Map<class_1792, CatalystEntry> REGISTRY = new HashMap<class_1792, CatalystEntry>();

    public static void register(class_1792 item, Catalyst catalyst, DisenchanterConfig.CatalystConfig config) {
        if (REGISTRY.containsKey(item)) {
            throw new IllegalArgumentException("Attempted to register catalyst for item " + item + "twice");
        }
        if (!config.enabled) {
            return;
        }
        REGISTRY.put(item, new CatalystEntry(catalyst, config.required_item_count));
    }

    public static void registerFromConfig(class_1792 item, Catalyst catalyst) {
        CatalystRegistry.register(item, catalyst, Disenchanter.getConfig().catalysts.get(class_7923.field_41178.method_10221((Object)item).toString()));
    }

    public static Catalyst get(class_1799 stack) {
        CatalystEntry entry = REGISTRY.get(stack.method_7909());
        if (entry == null) {
            return Catalyst.DEFAULT;
        }
        if (stack.method_7947() < entry.amount) {
            return Catalyst.DEFAULT;
        }
        return entry.catalyst;
    }

    public static Catalyst getUnchecked(class_1799 stack) {
        CatalystEntry entry = REGISTRY.get(stack.method_7909());
        return entry == null ? Catalyst.DEFAULT : entry.catalyst;
    }

    public static int getRequiredItemCount(Catalyst catalyst) {
        Optional<CatalystEntry> candidate = REGISTRY.values().stream().filter(catalystEntry -> catalystEntry.catalyst == catalyst).findAny();
        return candidate.isEmpty() ? -1 : candidate.get().amount;
    }

    public static void forEach(BiConsumer<class_1792, CatalystEntry> action) {
        REGISTRY.forEach(action);
    }

    public static boolean isCatalyst(class_1792 item) {
        return REGISTRY.containsKey(item);
    }

    public static List<class_1792> getCatalysts() {
        return new ArrayList<class_1792>(REGISTRY.keySet());
    }

    public record CatalystEntry(Catalyst catalyst, int amount) {
    }
}

