/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3920;
import net.minecraft.class_3956;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class StoveBlockEntity
extends SyncedBlockEntity {
    private static final class_265 GRILLING_AREA = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final int INVENTORY_SLOT_COUNT = 6;
    private final ItemStackHandlerContainer inventory = this.createHandler();
    private final int[] cookingTimes = new int[6];
    private final int[] cookingTimesTotal = new int[6];
    private class_2960[] lastRecipeIDs = new class_2960[6];

    public StoveBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.STOVE.get(), pos, state);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10545("Inventory")) {
            this.inventory.deserializeNBT(compound.method_10562("Inventory"));
        } else {
            this.inventory.deserializeNBT(compound);
        }
        if (compound.method_10573("CookingTimes", 11)) {
            int[] arrayCookingTimes = compound.method_10561("CookingTimes");
            System.arraycopy(arrayCookingTimes, 0, this.cookingTimes, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimes.length));
        }
        if (compound.method_10573("CookingTotalTimes", 11)) {
            int[] arrayCookingTimesTotal = compound.method_10561("CookingTotalTimes");
            System.arraycopy(arrayCookingTimesTotal, 0, this.cookingTimesTotal, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimesTotal.length));
        }
    }

    public void method_11007(class_2487 compound) {
        this.writeItems(compound);
        compound.method_10539("CookingTimes", this.cookingTimes);
        compound.method_10539("CookingTotalTimes", this.cookingTimesTotal);
    }

    private class_2487 writeItems(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        return compound;
    }

    public static void cookingTick(class_1937 level, class_2338 pos, class_2680 state, StoveBlockEntity stove) {
        boolean isStoveLit = (Boolean)state.method_11654((class_2769)StoveBlock.LIT);
        if (stove.isStoveBlockedAbove()) {
            if (!ItemUtils.isInventoryEmpty((class_1263)stove.inventory)) {
                ItemUtils.dropItems(level, pos, (ItemStackHandler)stove.inventory);
                stove.inventoryChanged();
            }
        } else if (isStoveLit) {
            stove.cookAndOutputItems();
        } else {
            for (int i = 0; i < stove.inventory.getSlotCount(); ++i) {
                if (stove.cookingTimes[i] <= 0) continue;
                stove.cookingTimes[i] = class_3532.method_15340((int)(stove.cookingTimes[i] - 2), (int)0, (int)stove.cookingTimesTotal[i]);
            }
        }
    }

    public static void animationTick(class_1937 level, class_2338 pos, class_2680 state, StoveBlockEntity stove) {
        for (int i = 0; i < stove.inventory.getSlotCount(); ++i) {
            if (stove.inventory.getStackInSlot(i).method_7960() || !(level.field_9229.method_43057() < 0.2f)) continue;
            class_241 stoveItemVector = stove.getStoveItemOffset(i);
            class_2350 direction = (class_2350)state.method_11654((class_2769)StoveBlock.FACING);
            int directionIndex = direction.method_10161();
            class_241 offset = directionIndex % 2 == 0 ? stoveItemVector : new class_241(stoveItemVector.field_1342, stoveItemVector.field_1343);
            double x = (double)pos.method_10263() + 0.5 - (double)((float)direction.method_10148() * offset.field_1343) + (double)((float)direction.method_10170().method_10148() * offset.field_1343);
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.5 - (double)((float)direction.method_10165() * offset.field_1342) + (double)((float)direction.method_10170().method_10165() * offset.field_1342);
            for (int k = 0; k < 3; ++k) {
                level.method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    private void cookAndOutputItems() {
        if (this.field_11863 == null) {
            return;
        }
        boolean didInventoryChange = false;
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            class_1799 resultStack;
            class_1799 stoveStack = this.inventory.getStackInSlot(i);
            if (stoveStack.method_7960()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] < this.cookingTimesTotal[i]) continue;
            class_1277 inventoryWrapper = new class_1277(new class_1799[]{stoveStack});
            Optional<class_3920> recipe = this.getMatchingRecipe((class_1263)inventoryWrapper, i);
            if (recipe.isPresent() && !(resultStack = recipe.get().method_8110(this.field_11863.method_30349())).method_7960()) {
                ItemUtils.spawnItemEntity(this.field_11863, resultStack.method_7972(), (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0, (double)this.field_11867.method_10260() + 0.5, this.field_11863.field_9229.method_43059() * (double)0.01f, 0.1f, this.field_11863.field_9229.method_43059() * (double)0.01f);
            }
            this.inventory.setStackInSlot(i, class_1799.field_8037);
            didInventoryChange = true;
        }
        if (didInventoryChange) {
            this.inventoryChanged();
        }
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            class_1799 slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.method_7960()) continue;
            return i;
        }
        return -1;
    }

    public boolean addItem(class_1799 itemStackIn, class_3920 recipe, int slot) {
        class_1799 slotStack;
        if (0 <= slot && slot < this.inventory.getSlotCount() && (slotStack = this.inventory.getStackInSlot(slot)).method_7960()) {
            this.cookingTimesTotal[slot] = recipe.method_8167();
            this.cookingTimes[slot] = 0;
            this.inventory.setStackInSlot(slot, itemStackIn.method_7971(1));
            this.lastRecipeIDs[slot] = recipe.method_8114();
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public Optional<class_3920> getMatchingRecipe(class_1263 recipeWrapper, int slot) {
        class_1860 recipe;
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        if (this.lastRecipeIDs[slot] != null && (recipe = ((RecipeManagerAccessor)this.field_11863.method_8433()).getRecipeMap(class_3956.field_17549).get(this.lastRecipeIDs[slot])) instanceof class_3920 && recipe.method_8115(recipeWrapper, this.field_11863)) {
            return Optional.of((class_3920)recipe);
        }
        return this.field_11863.method_8433().method_8132(class_3956.field_17549, recipeWrapper, this.field_11863);
    }

    public ItemStackHandlerContainer getInventory() {
        return this.inventory;
    }

    public boolean isStoveBlockedAbove() {
        if (this.field_11863 != null) {
            class_2680 above = this.field_11863.method_8320(this.field_11867.method_10084());
            return class_259.method_1074((class_265)GRILLING_AREA, (class_265)above.method_26218((class_1922)this.field_11863, this.field_11867.method_10084()), (class_247)class_247.field_16896);
        }
        return false;
    }

    public class_241 getStoveItemOffset(int index) {
        float X_OFFSET = 0.3f;
        float Y_OFFSET = 0.2f;
        class_241[] OFFSETS = new class_241[]{new class_241(0.3f, 0.2f), new class_241(0.0f, 0.2f), new class_241(-0.3f, 0.2f), new class_241(0.3f, -0.2f), new class_241(0.0f, -0.2f), new class_241(-0.3f, -0.2f)};
        return OFFSETS[index];
    }

    private void addParticles() {
        if (this.field_11863 == null) {
            return;
        }
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            if (this.inventory.getStackInSlot(i).method_7960() || !(this.field_11863.field_9229.method_43057() < 0.2f)) continue;
            class_241 stoveItemVector = this.getStoveItemOffset(i);
            class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)StoveBlock.FACING);
            int directionIndex = direction.method_10161();
            class_241 offset = directionIndex % 2 == 0 ? stoveItemVector : new class_241(stoveItemVector.field_1342, stoveItemVector.field_1343);
            double x = (double)this.field_11867.method_10263() + 0.5 - (double)((float)direction.method_10148() * offset.field_1343) + (double)((float)direction.method_10170().method_10148() * offset.field_1343);
            double y = (double)this.field_11867.method_10264() + 1.0;
            double z = (double)this.field_11867.method_10260() + 0.5 - (double)((float)direction.method_10165() * offset.field_1342) + (double)((float)direction.method_10170().method_10165() * offset.field_1342);
            for (int k = 0; k < 3; ++k) {
                this.field_11863.method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    @Override
    public class_2487 method_16887() {
        return this.writeItems(new class_2487());
    }

    private ItemStackHandlerContainer createHandler() {
        return new ItemStackHandlerContainer(6){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

